import {Component, Mixins, Prop, Watch} from 'vue-property-decorator';
import { Getter, State } from 'vuex-class';
import { reduce, ceil, subtract, divide, cloneDeep, assign } from 'lodash';
import ContextMenuMixin from '@editor/mixins/contextMenu.mixin';
import Upload from '../DynamicForm/component/Upload/index.vue';
import ColorSelector from '../DynamicForm/component/ColorSelector/index.vue';
import BaseSelect from '../DynamicForm/component/BaseSelect/index.vue';
import Textarea from '../DynamicForm/component/Textarea/index.vue';
import Number from '../DynamicForm/component/Number/index.vue';
import FormList from '../DynamicForm/component/FormList/index.vue';
import { resizeDiv, getStyle } from '@/service/utils.service';

@Component({ components: { Upload, ColorSelector, BaseSelect, Textarea, Number, FormList }, name: 'DynamicForm' })
export default class DynamicPageForm extends Mixins(ContextMenuMixin) {
  @Getter('pageData') pageData;

  title: string = '页面';
  commonStyleForm: object = {};
  propsForm: object = {};
  commonStyleSchame: object[] = [
    {
      key: 'backgroundImage',
      name: '背景图片',
      type: 'Upload',
    },
    {
      key: 'backgroundColor',
      name: '背景颜色',
      type: 'ColorSelector'
    }
  ];

  propsSchame: object[] = [
    {
      key: 'showPageBottomTip',
      name: '底部提示',
      type: 'checkbox'
    },
    {
      key: 'pageBottomTxt',
      name: '提示文案',
      type: 'Input'
    },
    {
      key: 'pageBottomColor',
      name: '提示颜色',
      type: 'ColorSelector'
    },
    {
      key: 'showBackTop',
      name: '返回顶部',
      type: 'checkbox'
    },
    {
      key: 'btAttachVal',
      name: '添加按钮',
      desc: '添加按钮',
      type: 'FormList',
      formControl: [
        {
          key: 'name',
          name: '名称',
          type: 'text'
        },
        {
          key: 'url',
          name: '链接',
          type: 'text'
        },
        {
          key: 'icon',
          name: '图片',
          type: 'Upload'
        },
        {
          key: 'color',
          name: '文字颜色',
          type: 'ColorSelector'
        },
        {
          key: 'background',
          name: '背景颜色',
          type: 'ColorSelector'
        }
      ]
    },
  ];

  @Watch('pageData', { immediate: true, deep: true })
  onElementChange(newVal) {
    this.commonStyleSchame.forEach(schame => {
      this.$set(this.commonStyleForm, schame.key, this.pageData?.commonStyle[schame.key]);
    });
    this.propsSchame.forEach(schame => {
      this.$set(this.propsForm, schame.key, this.pageData?.props?.[schame.key]);
    });
  }

  @Watch('commonStyleForm', { immediate: true, deep: true })
  onCommonStyleFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'commonStyle');
  }

  @Watch('propsForm', { immediate: true, deep: true })
  onPropsFormChange(newVal) {
    this.$emit('modProps', newVal, 'page', 'props');
  }
}