export function ok(data) {
  if (typeof data === 'string') {
    return {
      code: '0001',
      businessCode: '0000',
      message: data,
    };
  }

  return {
    code: '0000',
    businessCode: '0000',
    data,
  };
}

export function fail({ message = '服务异常', code = '0001', businessCode = '0001' }) {
  return {
    code,
    businessCode,
    message,
  };
}
