
const path = require('path');
import { Application, EggAppConfig } from 'egg';

export default (appInfo: EggAppConfig) => {
  const { mysql, redis } = require(path.resolve('./config/apollo.json'));
  const exports: any = {};
  exports.logger = {
    dir: '/home/quant_group/logs',
  };

  exports.sequelize = {
    dialect: 'mysql',
    ...mysql.low_code
  };

  exports.redis = {
    default: {
      keyPrefix: appInfo.name + ':',
    },
    client: redis
  };
  return exports;
};
