import { Vue, Component, Prop, Watch } from 'vue-property-decorator';
import iView from 'iview';
import cherryUi from '@qg/cherry-ui';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import { release } from '@/.sentryclirc';
import VueContextMenu from '@editor/component/Contextmenu/index';
import localStorage from '@/service/localStorage.service';
import 'iview/dist/styles/iview.css';
import '@qg/cherry-ui/dist/cherry.css';

Vue.use(iView);
Vue.use(cherryUi);
Vue.use(VueContextMenu);

// 初始化sentry
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('http://0785298052fd46128e201f30ca649102@sentry.q-gp.com/64', {
    release,
    environment: 'production'
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

@Component({
  name: 'Layout',
})
export default class Layout extends Vue {
  activeName: string = 'list';
  username: string = localStorage.get('user')?.name || '陌生人';

  get isDashboard() {
    return this.activeName === 'detail';
  }

  @Watch('$route', { immediate: true })
  onRouteChange(to) {
    this.activeName = to.name;
  }

  select(name) {
    this.$router.push({
      name
    });
  }

  logOut() {
    localStorage.clear();
    window.location.href = '/editor/login';
  }

  created() {
    console.log('>>EASY_ENV_IS_NODE create', EASY_ENV_IS_NODE);
  }
}