import {Component, Vue } from 'vue-property-decorator';
import { Mutation, Getter } from 'vuex-class';
import { cloneDeep } from 'lodash';

@Component({ name: 'GoodsTabsMixin' })
export default class GoodsTabsMixin extends Vue {
  @Getter('pageData') pageData;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;
  @Mutation('COPY_OR_DELETE_PAGE_INFO') updatePageData;

  handleGoodsTabs() {
    const goodsTabs = {};
    const pageData = cloneDeep(this.pageData);
    pageData.elements.forEach((element, idx) => {
      if (element.name === 'cs-goods-tabs' && element?.props?.list.length) {
        const childs = [];
        const childIndexs = [];
        const idList = element.props.list.map(v => v.componentId);
        if (idList.length && idList.length !== Array.from(new Set(idList)).length) {
          throw new Error('商品标签不可重复选择组件');
        }
        element.props.list.forEach((data, index) => {
          const index = pageData.elements.findIndex(v => v.id === data.componentId);
          if (index !== -1) {
            childIndexs.push(index);
            childs.push(pageData.elements[index]);
          }
        });
        goodsTabs[element.id] = { idx, childs, childIndexs };
      }
    });
    Object.keys(goodsTabs).forEach(key => {
      const { idx, childIndexs, childs } = goodsTabs[key];
      pageData.elements[idx].child = childs;
      // 逆向循环
      for (let i = childIndexs.length - 1; i >= 0; i--) {
        pageData.elements.splice(childIndexs[i], 1);
      }
    });

    return pageData;
  }

  parseGoodsTabs() {
    const goodsTabs = {};
    this.pageData.elements.forEach((element, idx) => {
      if (element.name === 'cs-goods-tabs' && element?.child?.length) {
        goodsTabs[idx] = cloneDeep(element.child);
        // 逆向循环
        for (let i = element.child.length - 1; i >= 0; i--) {
          this.updatePageData({ type: 'delete', containerIndex: idx, childIndex: i });
        }
      }
    });
    console.log('parseGoodsTabs', goodsTabs);
    Object.keys(goodsTabs).forEach(key => {
      goodsTabs[key].forEach((child, index) => {
        // console.log('parseGoodsTabs', { containerIndex: +key + 1 + index, data: child });
        this.updatePageInfo({ containerIndex: +key + 1 + index, data: child });
      });
    });
  }
}