import http from '../service/http.service';
import config from '../config';

export default {
  getPageList(params) {
    return http.get('editor/get/list', { params });
  },
  getPageById(params) {
    return http.get(`editor/get/${params.pageId}`);
  },
  delPageById(pageId) {
    return http.delete(`editor/${pageId}`);
  },
  updatePage(params) {
    return http.post(`editor/update`, params);
  },
  savePage(params) {
    return http.post(`editor/save`, params);
  },
  getTemplateList() {
    return http.get('editor/get/template');
  },
  // 商品列表-查询
  skuInfo(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/sku-info/list`, params, {
      accessToken: true
    });
  },
  // 获取商品类目
  categoryQuery() {
    return http.get(`${config.opapiHost}/kdspOp/api/kdsp/op/rear-category/query/all`, {
      accessToken: true
    });
  },
  // 优惠券搜索列表
  couponList(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/op/coupon/list`, params, {
      accessToken: true
    });
  },
  // 商品管理-商品专题列表_分页
  specialPage(params) {
    return http.post(`${config.opapiHost}/kdspOp/api/kdsp/activity/activity-goods/special/list-page`, params, {
      accessToken: true
    });
  },
  // todo: 对外接口需提供x-auth-token
  // 购物车-添加商品
  addShopCart(params) {
    return http.post(`${config.kdspHost}/api/kdsp/shop-cart/add-update`, params, {
      hideToken: true,
      headers: {
        'x-auth-token': '7386386a-3a78-41f9-8584-14933823bf20'
      }
    });
  },
  // 商品组或专题查询
  getGoods(params) {
    return http.post(`${config.kdspHost}/api/kdsp/activity/activity-goods-special/skus`, params);
    // return {
    //   skus: [
    //     {
    //       skuNo: '100014565800',
    //       skuName: '【自营】【自营】小米手机 陶瓷黑 8GB+128GB 官方标配',
    //       skuUrl: 'https://img14.360buyimg.com/n0/jfs/t1/141986/32/5318/98164/5f3236baE713fd239/5f2746db41f3e9c0.jpg',
    //       salePrice: 2.85,
    //       marketPrice: 293
    //     },
    //     {
    //       skuNo: '100014565820',
    //       skuName: '【自营】[自营][自营]0',
    //       skuUrl: 'https://img14.360buyimg.com/n0/jfs/t1/141986/32/5318/98164/5f3236baE713fd239/5f2746db41f3e9c0.jpg',
    //       salePrice: 264,
    //       marketPrice: 300
    //     },
    //     {
    //       skuNo: '100014565820',
    //       skuName: '【自营】[自营][自营]0',
    //       skuUrl: 'https://img14.360buyimg.com/n0/jfs/t1/141986/32/5318/98164/5f3236baE713fd239/5f2746db41f3e9c0.jpg',
    //       salePrice: 264,
    //       marketPrice: 300
    //     },
    //     {
    //       skuNo: '100014565800',
    //       skuName: '【自营】【自营】小米手机 陶瓷黑 8GB+128GB 官方标配',
    //       skuUrl: 'https://img14.360buyimg.com/n0/jfs/t1/141986/32/5318/98164/5f3236baE713fd239/5f2746db41f3e9c0.jpg',
    //       salePrice: 2.85,
    //       marketPrice: 293
    //     },
    //     {
    //       skuNo: '100014565820',
    //       skuName: '【自营】[自营][自营]0',
    //       skuUrl: 'https://img14.360buyimg.com/n0/jfs/t1/141986/32/5318/98164/5f3236baE713fd239/5f2746db41f3e9c0.jpg',
    //       salePrice: 264,
    //       marketPrice: 300
    //     },
    //     {
    //       skuNo: '100014565820',
    //       skuName: '【自营】[自营][自营]0',
    //       skuUrl: 'https://img14.360buyimg.com/n0/jfs/t1/141986/32/5318/98164/5f3236baE713fd239/5f2746db41f3e9c0.jpg',
    //       salePrice: 264,
    //       marketPrice: 300
    //     }
    //   ]
    // };
  },
  // 根据id查询优惠券列表
  getCoupons(params) {
    return http.get(`${config.kdspHost}/api/kdsp/coupon/list`, {
      params,
      hideToken: true,
      headers: {
        'x-auth-token': '7386386a-3a78-41f9-8584-14933823bf20'
      }
    });
    // return {
    //   coupons: [
    //     {
    //       id: 1,
    //       pickupId: 1,
    //       name: '3C数码会场',
    //       startDate: '2021-02-22',
    //       endDate: '2021-02-22',
    //       faceValue: 100,
    //       limitAmount: 300,
    //       limitDesc: '满300减100',
    //       couponCategory: 1,
    //       iconUrl: 'in esse',
    //       description: 'officia do',
    //       status: 19667180,
    //       navUrl: 'exercitation est',
    //       pickupAble: false,
    //       publishCountFinished: false
    //     },
    //     {
    //       id: 2,
    //       pickupId: 1,
    //       name: '3C数码会场',
    //       startDate: '2021-02-22',
    //       endDate: '2021-02-22',
    //       faceValue: 100,
    //       limitAmount: 300,
    //       limitDesc: '满300减100',
    //       couponCategory: 1,
    //       iconUrl: 'oc',
    //       description: 'minim dolore tempor',
    //       status: 63205995,
    //       navUrl: 'cupidat',
    //       pickupAble: true,
    //       publishCountFinished: false
    //     },
    //     {
    //       id: 3,
    //       pickupId: 1,
    //       name: '3C数码会场',
    //       startDate: '2021-02-22',
    //       endDate: '2021-02-22',
    //       faceValue: 100,
    //       limitAmount: 300,
    //       limitDesc: '满300减100',
    //       couponCategory: 1,
    //       iconUrl: 'eu fugiat commodo voluptate exercitation',
    //       description: 'nisi',
    //       status: 43999314,
    //       navUrl: 'commodo in reprehenderit',
    //       pickupAble: false,
    //       publishCountFinished: true
    //     },
    //     {
    //       id: 4,
    //       pickupId: 1,
    //       name: '3C数码会场',
    //       startDate: '2021-02-22',
    //       endDate: '2021-02-22',
    //       faceValue: 100,
    //       limitAmount: 300,
    //       limitDesc: '满300减100',
    //       couponCategory: 1,
    //       iconUrl: 'eu fugiat commodo voluptate exercitation',
    //       description: 'nisi',
    //       status: 43999314,
    //       navUrl: 'commodo in reprehenderit',
    //       pickupAble: false,
    //       publishCountFinished: true
    //     }
    //   ]
    // };
  },
  // 领取优惠券
  pickupCoupon(params) {
    return http.post(`${config.kdspHost}/api/kdsp/coupon/pickup`, params, {
      hideToken: true,
      // todo: header里二者参数需特殊处理
      headers: {
        'x-user-terminal': 'H5',
        'vccChannel': '',
        'x-auth-token': ''
      },
    });
  },
};