import {Component, Vue } from 'vue-property-decorator';

@Component({ name: 'dynamicFormMixin' })
export default class DynamicFormMixin extends Vue {
  getComponent(type) {
    let result = type;
    switch (type) {
    case 'text':
      result = 'Input';
      break;
    case 'select':
      result = 'BaseSelect';
      break;
    case 'checkbox' :
      result = 'Checkbox';
      break;
    case 'textarea' :
      result = 'Textarea';
      break;
    case 'number' :
      result = 'Number';
      break;
    }
    return result;
  }
}