/**
 * @desc 页面信息表
 */
import { AutoIncrement, Column, DataType, Model, PrimaryKey, Table, AllowNull } from 'sequelize-typescript';

@Table({
  modelName: 'page_config_info',
  freezeTableName: true
})

export class PageInfo extends Model<PageInfo> {

  @PrimaryKey
  @AutoIncrement
  @Column({
    type: DataType.INTEGER(11)
  })
  id: number;

  @Column({
    field: 'page_data',
    type: DataType.TEXT
  })
  page: string;

  @Column({
    field: 'page_name',
    type: DataType.STRING(32)
  })
  pageName: string;

  @Column({
    field: 'page_describe',
    type: DataType.STRING(255)
  })
  pageDescribe: string;

  @Column({
    field: 'page_keywords',
    type: DataType.STRING(255)
  })
  pageKeywords: string;

  @Column({
    field: 'uuid',
    type: DataType.UUID
  })
  uuid: string;

  @Column({
    type: DataType.INTEGER(1)
  })
  enable: number;

  @AllowNull(false)
  @Column({
    type: DataType.STRING(32)
  })
  author: string;

  @Column({
    type: DataType.STRING(32),
    field: 'cover_image'
  })
  coverImage: string;

  @Column({
    type: DataType.INTEGER(1),
    field: 'is_template'
  })
  isTemplate: number;

  @Column({
    type: DataType.INTEGER(1),
    field: 'is_publish'
  })
  isPublish: number;

  @Column({
    type: DataType.DATE,
    field: 'updated_at',
    get() {
      const moment = require('moment');
      const updatedAt = this.getDataValue('updatedAt');
      return moment(updatedAt).format('YYYY-MM-DD HH:mm:ss');
    },
  })
  updatedAt: string;

  @Column({
    type: DataType.INTEGER(11),
    field: 'tenant_id',
  })
  tenantId: number;
}

export default () => PageInfo;