import Vue from 'vue';
import VueRouter from 'vue-router';
import Dashboard from '../view/dashboard/index.vue';
import PageList from '../view/pageList/index.vue';
import MyPage from '../view/myPage/index.vue';
import Template from '../view/template/index.vue';
import localStorage from '@/service/localStorage.service';

Vue.use(VueRouter);

export default function createRouter() {
  const router = new VueRouter({
    mode: 'history',
    base: window.__POWERED_BY_QIANKUN__ ? '/micro/quantum-blocks' : '/editor',
    routes: [
      {
        path: '/',
        redirect: 'list'
      },
      {
        name: 'detail',
        path: '/detail/:pageId?',
        component: Dashboard
        // component: () => import('../view/dashboard/index.vue')
      },
      {
        name: 'list',
        path: '/list',
        component: PageList
        // component: () => import('../view/pageList/index.vue')
      },
      {
        name: 'my',
        path: '/my',
        component: MyPage
        // component: () => import('../view/myPage/index.vue')
      },
      {
        name: 'template',
        path: '/template',
        component: Template
        // component: () => import('../view/template/index.vue')
      },
    ]
  });

  router.beforeEach(async (to, from, next) => {
    if (to.path !== '/login') {
      if (!localStorage.get('token')) {
        return window.location.href = '/editor/login';
      }
    }

    next();
  });

  return router;
}
