import { Component, Vue } from 'vue-property-decorator';

let lastTouchEnd = 0;

@Component({ name: 'DisableTouchMixin' })
export default class DisableTouchMixin extends Vue {
  disTouch(e) {
    const now = (new Date()).getTime();
    if (now - lastTouchEnd <= 300) {
      e.preventDefault();
      return false;
    }
    lastTouchEnd = now;
  }
}
