#!/usr/bin/env node

"use strict";
const path = require('path');
const fs = require('fs');
const apollo = require('@qg/apollo-nodejs');

const npm = require("npm");
npm.load(() => {
  apollo.load({
    appId: 'quantum-block-h5',
    configPath: path.resolve(__dirname, '../config'),
  }).then(() => {
    const { api, qiniu } = require(path.resolve('./config/apollo.json'));
    fs.writeFileSync(path.resolve('./config/apollo.ssr.json'), JSON.stringify({ ...api, ...qiniu }));
  });

});

 