// import store from '../store';
import { isWechat, isApp, errorQueryValues } from './utils.service';
import Cookies from './cookieStorage.service';
import localStorage from './localStorage.service';
// formXcxPage:标识是从小程序跳转过来的;
const localStorageParams = ['creditToken', 'vccToken', 'vccChannel', 'sonVccChannel', 'formXcxPage'];
const cookiesParams = ['h'];

export default {
  // token校验，整个流程都是登陆后的
  init: router => {
    router.beforeEach((to, from, next) => {
      // 所有自定义路由字段在此处理
      const { meta } = to;

      // meta?.has?.header && store.commit('CHANGE_HEADER', meta.has.header); // 改变header
      if (router.mode === 'history' && !to.hash) {
        localStorageParams.forEach(item => {
          if (to.query[item] && errorQueryValues.indexOf(to.query[item]) === -1) {
            localStorage.set(item, to.query[item]);
          } else {
            localStorage.set(item, '');
          }
        });
        cookiesParams.forEach(item => {
          if (to.query[item] && errorQueryValues.indexOf(to.query[item]) === -1) {
            Cookies.set(item, to.query[item]);
          } else {
            Cookies.remove(item);
          }
        });
      }

      // (isWechat || isApp || Cookies.get('h') === '0') && store.commit('CHANGE_HEADER', false); // 改变header
      // document.body.className = store.state.pay.header ? 'has-header' : '';
      // store.commit('CHANGE_TITLE', meta?.title); // 改变title

      next();
    });
  }
};