import { Controller, Context } from 'egg';
import { off } from 'process';
export default class ActivityController extends Controller {

  public async home(ctx: Context) {
    // 开发环境不走redis缓存
    const apollo = ctx.app.config.apollo || {};
    let body = '';
    if (process.env.NODE_ENV === 'development') {
        body = await ctx.renderToHtml('activity.js', { url: ctx.url, apollo });
    } else {
      const redisKey = `quantum-blocks:page:${ctx.params.id}`;
      body = await ctx.service.redis.get(redisKey);
      console.log('quantum-blocks body :>> ', body);
      if (body) {
        ctx.logger.info('请求redis成功 key: %j', redisKey);
      }
      if (!body) {
        body = await ctx.renderToHtml('activity.js', { url: ctx.url, apollo });
        console.log('body2 :>> ', body);
        await ctx.service.redis.set(redisKey, body);
      }
    }
    ctx.body = body;
  }

  public async history(ctx: Context) {
    // 获取页面历史记录页面数据
    const apollo = ctx.app.config.apollo || {};
    const body = await ctx.renderToHtml('activity.js', { url: ctx.url, apollo });
    ctx.body = body;
  }
}
