import { Vue, Component, Prop } from 'vue-property-decorator';
import { Getter } from 'vuex-class';
import 'intersection-observer';
// import { release } from '@/.sentryclirc';
import { init as sentryInit } from '@sentry/vue';
import '@/service/qg.service';
import SaDirective from '@qg/citrus-ui/src/helper/directives/saTrack.directive.js';
import config from '@qg/citrus-ui/src/config/index.js';
import { EventBus } from '@qg/citrus-ui/src/helper/service/eventBus';
import { getParameterByName } from '../../../service/utils.service';
import localStorage from '../../../service/localStorage.service';
import lazyload from '@qg/cherry-ui/src/lazyload/index';
import { SSL_OP_ALLOW_UNSAFE_LEGACY_RENEGOTIATION } from 'constants';

// 初始化sentry
if (EASY_ENV_IS_BROWSER && process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  sentryInit({
    Vue,
    dsn: 'https://a8c47fa8d2cb4e099490ed893c0d1577@sentry.q-gp.com/32', // 项目设置中的Client Keys
    release: 'quantum-block-h5@1.0.0', // 项目名加版本号
    tracesSampleRate: 0.5, // 上报频率, 1最大, 0最小, 建议验证设置为1, 项目运行根据情况降低频率
    environment: process.env.NODE_ENV
  });
}

if (EASY_ENV_IS_BROWSER && process.env.SENTRY_ENV === 'test') {
  // ! 上线后务必取掉;
  // const vConsole = require('vconsole');
  // new vConsole();
}

if (EASY_ENV_IS_BROWSER) {
  // ios回退刷新，防止缓存
  const isSafari = /^.*((iPhone)|(iPad)|(Safari))+.*$/;
  const fromHost = getParameterByName('fromHost', window.location.href);
  if (isSafari.test(navigator.userAgent) && fromHost?.indexOf('xc.bmall') === -1 && fromHost?.indexOf('tob') === -1) {
    window.onpageshow = function(e) {
      if (e.persisted || (window.performance && window.performance.navigation.type === 2)) {
        window.location.reload();
      }
    };
  }
  Vue.use(lazyload);
  const saDirective = new SaDirective();
  Vue.directive('track', saDirective.directive);
  Vue.config.ignoredElements = ['wx-open-launch-weapp', 'wx-open-launch-app'];
  // 全局app登录态监听
  window.xyqbNativeEvent = function(res) {
    const json = typeof res === 'string' ? JSON.parse(res) : res;
    console.log('xyqbNativeEvent toggle');
    if (json.event === 'loginAndLogoutNotification') {
      EventBus.$emit('NATIVE_EVENT_LOGIN', json);
    }
    if (json.event === 'getTokenSuccess') {
      EventBus.$emit('NATIVE_EVENT_GET_TOKEN', json);
    }
    if (json.event === 'getShuMeiIdSuccess') {
      EventBus.$emit('NATIVE_EVENT_GET_SHUMEI_ID', json);
    }
  };
}
@Component({
  name: 'Layout'
})
export default class Layout extends Vue {
  @Getter('pageInfo') pageInfo;

  isNode: boolean = EASY_ENV_IS_NODE;

  scriptSrc: string[] = [
    // `<script src="https://activitystatic.91xr.cn/vue/2.6.11/vue.min.js"></script>`,
    // `<script src="https://activitystatic.91xr.cn/vue-router/3.2.0/vue-router.min.js"></script>`,
    // `<script src="https://activitystatic.91xr.cn/vuex/3.4.0/vuex.min.js"></script>`,
    `<script src="https://activitystatic.91xr.cn/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`,
    `<script src="https://activitystatic.91xr.cn/swiper/4.5.1/swiper.min.js"></script>`,
    `<script src="https://activitystatic.91xr.cn/axios/0.19.2/axios.min.js"></script>`
  ];
  talosHost: string = config.kdspHost;
  get title() {
    return this.pageInfo.title || this.defaultTitle();
  }

  get description() {
    return this.pageInfo.description || this.defaultTitle();
  }

  get keywords() {
    return this.pageInfo.keywords || this.defaultTitle();
  }

  defaultTitle() {
    return +localStorage.get('tenantId') === 560761 ? $t('yangxiaomie') : $t('event.page');
  }
}