// 用于处理底部导航样式
import { Component, Vue } from 'vue-property-decorator';

@Component({ name: 'BottomNavStyleMixin' })

export default class BottomNavStyleMixin extends Vue {
  isHexColor(str) {
    const reg = /^(?:#[A-Fa-f0-9]{3}|#[A-Fa-f0-9]{6})$/;
    return reg.test(str);
  }
  computedNavContainerStyle(navGlobalConfig = {}) {
    const style = {};
    // 如果同时设置了背景色和背景图，优先使用背景图
    const { bgColor, bgImg } = navGlobalConfig;
    if (bgImg) {
      style.backgroundImage = `url(${bgImg})`;
      style.backgroundRepeat = 'no-repeat';
      style.backgroundSize = 'cover';
    } else if (!bgImg && bgColor) {
      // 没有背景图 使用背景色
      style.backgroundColor = bgColor.indexOf('#') === 0 ? bgColor : `#${bgColor}`;
    } else {
      // 默认白色背景
      style.backgroundColor = '#fff';
    }
    return style;
  }
  computedNavTextStyle(navConfig = {}, isCurrent = false) {
    const style = {};
    const { color, selectColor } = navConfig;
    if (isCurrent) {
      style.color = selectColor && this.isHexColor(selectColor) ? selectColor : '#fff';
    } else {
      style.color = color && this.isHexColor(color) ? color : '#fff';
    }
    return style;
    // if (co)
  }
}
