// tslint:disable
// import store from '@/store';
import Toast from '@qg/cherry-ui/src/toast';
import axios from 'axios';
import strategyModes from '@/config/http.config';

const ERR_MESSAGE_MAP = {
  status: {
    400: $t('bad.request'),
    401: $t('not.logged.in.or.session.expired.please.log.in.again'),
    403: $t('access.denied'),
    404: $t('request.error.resource.not.found'),
    405: $t('method.not.allowed'),
    408: $t('request.timeout'),
    500: $t('server.error'),
    501: $t('network.not.implemented'),
    502: $t('network.error'),
    503: $t('service.unavailable'),
    504: $t('network.timeout'),
    505: $t('http.version.not.supported')
  }
};
const defaultStratege = {
  default: {
    request(cfg) {
      return cfg;
    },
    response(res) {
      return res.data;
    }
  }
};

const config = {
  timeout: 15000
};
const CancelToken = axios.CancelToken;
const instance = axios.create(config);

const pending = {};
let reqNum = 0;
let timeId = null;
strategyModes.default = defaultStratege;

function beforeRequest() {
  reqNum++;
  clearTimeout(timeId);
  timeId = setTimeout(() => {
    // store.dispatch('change_loading', true);
  }, 1300);
}

function afterRequest() {
  reqNum--;
  if (reqNum <= 0) {
    clearRequest();
    // store.dispatch('change_loading', false);
  }
}

function clearRequest() {
  clearTimeout(timeId);
}

// 请求拦截器
instance.interceptors.request.use(
  config => {
    !config.hideLoading && beforeRequest(config?.url || '');
    // 发起请求时，取消掉当前正在进行的相同请求
    // if (pending[config.url]) {
    //   pending[config.url]('取消重复请求');
    // }
    // config.cancelToken = new CancelToken(c => (pending[config.url] = c));
    // 使用默认响应处理策略
    if (!config.strategy) {
      config.strategy = 'service';
    }
    if (strategyModes[config.strategy].request) {
      config = strategyModes[config.strategy].request(config);
    }
    return config;
  },
  error => {
    return [null, error];
  }
);

// 响应拦截器即异常处理
instance.interceptors.response.use(
  response => {
    if (response.config?.url) {
      !config.hideLoading && afterRequest();
      delete pending[response.config?.url || ''];
    }
    return strategyModes[response.config?.strategy].response(response);
  },
  err => {
    !config.hideLoading && afterRequest();

    let message = '';
    let showToast = !config.hideToast;

    if (err.message === 'Network Error' && !err.response) {
      // 网络异常: 错误域名，
      message = $t('service.unavailable');
    } else if (err.response && err.response?.status) {
      message =
        ERR_MESSAGE_MAP.status[err.response?.status] || `未知异常码: ${err.response?.status}`;
    } else if (err.message === $t('cancel.duplicate.request')) {
      message = $t('cancel.duplicate.request');
      showToast = false;
    }
    showToast && Toast(message || $t('service.error.please.retry.later'));
    const error = new Error(message);
    console.error(error);
    return [null, error];
  }
);
export default instance;
