import { Vue, Component, Watch, Provide, Mixins } from 'vue-property-decorator';
import { Getter, State, Mutation } from 'vuex-class';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import BackTop from '../../component/BackTop/index.vue';
import InvalidNotice from '../../component/invalidNotice/index.vue';
import CouponModal from '../../component/CouponModal/index.vue';
import EmptyState from '../../component/EmptyState/index.vue';
import PageBottomTip from '../../component/PageBottomTip/index.vue';
import GridLayout from '../../component/VueGridLayout/GridLayout.vue';
import GridItem from '../../component/VueGridLayout/GridItem.vue';
import TransformStyleMixin from '@/page/mixins/transformStyle.mixin';
import BottomNavStyleMixin from '@/page/mixins/BottomNavStyle.mixin';
import SaMixin from '@/page/mixins/sa.mixin';
import { getStyle, debounce, isApp, isWxMp, getParameterByName } from '@/service/utils.service';
import DisableTouchMixin from '@/page/mixins/disableTouch.mixin';
import { setAppTitleColor } from '@/service/color.service';
import { EventBus } from '@qg/citrus-ui/src/helper/service/eventBus';
import localStorage from '@/service/localStorage.service';
import { home, shopcart, user } from '@/config/nav.config';
import { isWxMp, isApp } from '@/service/utils.service';
import Bridge from '@qg/js-bridge';
import MpBridge from '@qg/citrus-ui/src/helper/service/mp';
import navigatorApi from '@/api/navigator.api';
import editorApi from '@/api/editor.api';
import modalApi from '@/api/modal.api';
import { getTokenFromApp } from '@qg/citrus-ui/src/helper/service/utils';
import { registeredEvents } from '@/service/sa.service';
@Component({ components: { FreedomContainer, GridLayout, GridItem, PageBottomTip, BackTop, InvalidNotice, EmptyState, CouponModal }, name: 'Activity'})
export default class Activity extends Mixins(TransformStyleMixin, BottomNavStyleMixin, SaMixin, DisableTouchMixin) {

  @Getter('pageData') pageData;
  @State(state => state.activity.pageInfo) pageInfo;
  @State(state => state.activity.pageInfo.pageName) pageName;
  @State(state => state.activity.noPageData) noPageData;
  @State(state => state.activity.pageInfo.appLoginState) appLoginState;
  @State(state => state.activity.pageInfo.tenantId) tenantId;
  @State(state => state.activity.gridLayout.rowHeight) rowHeight;

  @Mutation('SET_PAGE_ELEMENTS') setPageElement;
  @Mutation('UPDATE_APP_LOGIN_STATE') updateAppLoginState;

  @Provide() editor = this;
  isEditor: boolean = false;
  pageInvalid: boolean = false;
  bottomInfo: object = {
    x: 0,
    y: 0,
    w: 375,
    h: 60,
    i: 'page-bottom-top'
  };
  isLayoutComReady = false;
  showBackTop = false;
  navIndex = 0;
  navigatorConfig = null;
  targetEle: HTMLElement | null = null;
  loading: boolean = true;
  modfiTabsStyleDebounce = debounce(this.modfiTabsStyle, 300);
  showCouponModal: boolean = false;
  couponModalData: object = {};
  get layout() {
    if (!isApp && !isWxMp && !EASY_ENV_IS_NODE) {
      this.pageData.elements = this.$route.query.isPreview ? this.pageData.elements : this.pageData.elements.filter(v => v.name !== 'cs-search-bar' && v.name !== 'cs-snap-up' && v.name !== 'cs-seckill');
    }
    return this.pageData && this.pageData.elements.map(v => v.point) || [];
  }
  get tenantIdCorrect() {
    if (EASY_ENV_IS_NODE) {
      return true;
    }
    // TODO
    return +this.tenantId ? (+this.tenantId === +(localStorage.get('tenantId') || 560761)) : true;
  }

  @Watch('pageData', { deep: true })
  onPageDataChange(val) {
    const lastGridItem = val.elements[val.elements.length - 1];
    const lastGridItemPoint = lastGridItem?.point;
    if (lastGridItemPoint && lastGridItemPoint.w) {
      this.bottomInfo = {
        x: 0,
        y: 0,
        w: 375,
        h: 60,
        i: 'page-bottom-top'
      };
      if (lastGridItemPoint.w > this.bottomInfo.w) { this.bottomInfo.w = lastGridItemPoint.w; }
      this.bottomInfo.y = this.bottomInfo.y + lastGridItemPoint.y + lastGridItemPoint.h;
    }
    if (isApp) {
      // 当页面数据改变，并且渲染完成后改变app 标题栏颜色
      this.$nextTick(() => {
        debounce(setAppTitleColor(this.pageData.props.titleBgColor), 300);
      });
    }
  }

  @Watch('pageName', { immediate: true })
  onPageNameChange(newVal) {
    if (EASY_ENV_IS_BROWSER && newVal) {
      let title = newVal;
      // 支持运营内部福利赛需求，包括优惠券组件也做了处理，如果后期不用，可以考虑下线
      const pageTitleFromUrl = getParameterByName('pageTitle');
      if (this.pageData.props.titleUseUrl && pageTitleFromUrl) {
        title = pageTitleFromUrl;
      }
      document.title = title;
      // 如果是 iOS 设备，则使用如下 hack 的写法实现页面标题的更新
      if (navigator.userAgent.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/)) {
        const hackIframe = document.createElement('iframe');
        hackIframe.style.display = 'none';
        hackIframe.src = '/public/asset/fixIosTitle.html?r=' + Math.random();
        document.body.appendChild(hackIframe);
        setTimeout(() => {
          document.body.removeChild(hackIframe);
        }, 300);
      }
      // 适配
      this.modifyPoints();
    }
  }
  mounted() {
    if (!isApp && !isWxMp && !EASY_ENV_IS_NODE) {
      this.pageData.elements = this.$route.query.isPreview ? this.pageData.elements : this.pageData.elements.filter(v => v.name !== 'cs-search-bar' && v.name !== 'cs-snap-up' && v.name !== 'cs-seckill');
    }
    this.targetEle = document.querySelector('body');
    if (EASY_ENV_IS_BROWSER) { this.showBackTop = true; }
    this.pageVisibilityChange();
    if (EASY_ENV_IS_BROWSER) {
      EventBus.$on('NATIVE_EVENT_LOGIN', json => {
        console.log('xyqbNativeEvent got', json);
        if (json.event === 'loginAndLogoutNotification') {
          const appData = json.data || {};
          if (appData && appData.login) {
            localStorage.set('vccToken', appData.token);
            this.updateAppLoginState(true);
          } else {
            this.updateAppLoginState(false);
            localStorage.remove('vccToken');
          }
        }
      });
      console.log(this.$route);
      // 获取导航配置，不走redis改异步是因为页面缓存会把导航部分也缓存进去
      const {navId, index} = this.$route.query;
      if (navId && index) {
        this.getNavigatorConfig(navId, index);
      }
    }
    this.layoutReadyEvent();
  }
  async created() {
    if (EASY_ENV_IS_BROWSER) {
      const token = localStorage.get('vccToken') || '';
      // 检测页面是否需要强制登录
      if (this.pageData?.props?.pageNeedLogin && !token && (isApp || isWxMp)) {
        getTokenFromApp().then(() => {
          window.location.href = this.addOrEditUrlParams(window.location.href, 'vccToken', localStorage.get('vccToken'));
        });
        return;
      }
    }
    const appChannel = localStorage.get('appChannel') || '';
    const [res, ] = await editorApi.getFinanceSetting(appChannel);
    const [serverTime, ] = await editorApi.getServerTime();
    // console.log(res, 'finance result');
    // console.log(serverTime, 'time');
    if (res && res.showFlag === 0) {
      this.pageData.elements = this.pageData.elements.filter(v => v.name !== 'freedom-container' || !v.props.isFinance);
    }
    this.comparePageTime(serverTime); // 验证活动是否在设定的有效期范围内
    if (EASY_ENV_IS_BROWSER && isApp) {
      // 优惠券弹窗仅限app使用
      this.getCouponModalDetail();
    }
  }
  async getCouponModalDetail() {
    // 获取优惠券弹窗相关配置
    if (this.pageData?.props?.couponModal && this.pageData?.props?.couponModal.length) {
      const couponPushIdList = this.pageData.props.couponModal.join(',');
      // 先获取同盾ID，再调用优惠券弹窗推送接口
      if (EASY_ENV_IS_BROWSER) {
        if (isApp) {
          this.getCouponModalDetailReq(couponPushIdList);
          // // app的时候通过事件获取同盾id
          // EventBus.$on('NATIVE_EVENT_GET_TDONGDUN_ID', res => {
          //   console.log('getTongdunIdInAppSuccess', JSON.stringify(res));
          //   tongdunDeviceId = res.data.tongdunDeviceId || '';
          //   this.getCouponModalDetailReq(couponPushIdList, tongdunDeviceId);
          // });
          // const bridge = new Bridge();
          // bridge.run({
          //   event: 'getTongdunId',
          //   data: {},
          // });
        }
      }
    }
  },
  async getCouponModalDetailReq(couponPushIdList) {
    // 获取推送弹窗数据
    if (!couponPushIdList) { return; }
    const [res, err] = await modalApi.getCouponModal({
      couponPushIdList,
    });
    if (err) { return; }
    if (res && Object.keys(res).length) {
      this.couponModalData = res;
      this.showCouponModal = true;
      try {
        const popupwindow_name = res.couponPush && res.couponPush.componentName ? res.couponPush.componentName : '';
        const popupwindow_id = res.couponPush && res.couponPush.appConfigPushNo ? res.couponPush.appConfigPushNo : '';
        const coupon_id = res.couponList.map(item => item.id).join(',');
        registeredEvents('H5_ActivityPageCouponPopupExposure', {
          activity_id: this.pageInfo.uuid,
          popupwindow_name,
          popupwindow_id,
          coupon_id
        });
      } catch (e) {
        console.log(e);
      }
    }
  }
  comparePageTime(serverTime) {
    const { validStartTime, validEndTime } = this.pageInfo;
    // 获取服务器端当前时间，用于与页面有效期做对比
    if (validStartTime && validEndTime) {
      // 当设置了页面的有效时间起止，用当前服务器返回的时间作对比，判断页面是否在有效期内
      // const startTime = new Date(validStartTime).getTime();
      const endTime = new Date(validEndTime).getTime();
      if (serverTime > endTime) {
        this.pageInvalid = true;
      }
    }
  }
  toOtherActivity() {
    const { redirectUrl } = this.pageInfo;
    let nativeBridge;
    let mpBridge;
    if (isApp) {
      nativeBridge = new Bridge();
      nativeBridge.openNewUrl({
        data: {
          // 需要打开的新链接
          newUrl: redirectUrl ? redirectUrl : home.app,
        },
      });
    } else if (isWxMp) {
      mpBridge = new MpBridge();
      const jumpConfig: any = {
        // 需要打开的新链接
        newUrl: redirectUrl ? redirectUrl : home.wxmp,
      };
      if (!redirectUrl) { jumpConfig.type = 'switchTab'; }
      mpBridge.openNewUrl(jumpConfig);
    } else {
      if (!redirectUrl) { return; }
      let url = redirectUrl;
      const token = localStorage.get('vccToken') || '';
      const { vccChannel, fromHost } = this.$route.query;
      if (!isApp && !isWxMp) {
        if (vccChannel) { url = this.addOrEditUrlParams(url, 'vccChannel', vccChannel); }
        if (fromHost) { url = this.addOrEditUrlParams(url, 'fromHost', fromHost); }
      }
      if (token) { url = this.addOrEditUrlParams(url, 'vccToken', token); }
      window.location.href = url;
      return;
    }
  }
  async getNavigatorConfig(navId, index) {
    // 获取导航配置
    const [res] = await navigatorApi.getDetailById(navId);
    this.navigatorConfig = res;
    this.navIndex = index;
  }
  async fetchApi(options) {
    const { store, route } = options;
    const { pageId, id } = route.params;
    try {
      await store.dispatch('getFinanceSetting');
    } catch (err) {
      console.log(err);
    }
    if (route.name && route.name == 'history') {
      return store.dispatch('getHistoryPageData', { id });
    }
    return store.dispatch('getPageDate', { pageId });
  }
  updateShopCartCount() {
    if (EASY_ENV_IS_BROWSER) {
      this.$nextTick(() => {
        this.$refs.backTop.getCartCount();
      });
    }
  }
  modifyPoints() {
    const clientWidth = document.documentElement.clientWidth > 768 ? 375 : document.documentElement.clientWidth;
    const elements = this.pageData?.elements?.map(v => {
      const point = {
        ...v.point,
        h: v.point.h * this.rowHeight * clientWidth / 375,
        w: clientWidth
      };
      return { ...v, point };
    });
    this.setPageElement(elements);
  }

  dot(title) {
    console.log(title, '点击了');
  }
  fixGridKey(item) {
    if (typeof item.point?.i === 'number' && !isNaN(item.point?.i)) {
      return item.id;
    }
    return item.point?.i || '';
  }
  layoutReadyEvent(newLayout) {
    this.$nextTick(() => {
      const loadingEle = document.querySelector('.mainload');
      // console.log('loadingEle', loadingEle);
      if (!loadingEle) { return; }
      loadingEle.style.display = 'none';
      if (isApp) {
        setAppTitleColor(this.pageData.props.titleBgColor);
      }
    });
  }
  layoutUpdatedEvent() {
    // console.log('layoutUpdatedEvent');
    // 高度更新时重新计算导航组件样式
    this.modfiTabsStyleDebounce();
  }
  // overlay遮罩显示时隐藏悬浮窗
  hideBottomBtns(state) {
    this.showBackTop = state;
  }
  // overlay遮罩显示时，降低其他sticky的z-index (通过设置transform实现)
  setDownOtherEleZIndex(state, id) {
    const HAVE_Z_INDEX_EL = ['cs-floor-nav', 'cs-goods-tabs'];
    const elements = this.pageData?.elements?.map(item => {
      if (item.id !== id && HAVE_Z_INDEX_EL.includes(item.name)) {
        item.commonStyle.transform = state ? 'rotateZ(0)' : 'none';
      }
      return item;
    });
    this.setPageElement(elements);
    this.hideBottomBtns(!state);
  }
  // 处理页面隐藏
  pageVisibilityChange() {
    if (EASY_ENV_IS_NODE) { return; }
    let hidden = 'hidden';
    let visibilityChange = 'visibilitychange';
    if (typeof document.hidden !== 'undefined') {
      hidden = 'hidden';
      visibilityChange = 'visibilitychange';
    } else if (typeof document.webkitHidden !== 'undefined') {
      hidden = 'webkitHidden';
      visibilityChange = 'webkitvisibilitychange';
    }
    window.addEventListener(visibilityChange, () => {
      this.handleChange(document[hidden]);
      EventBus.$emit('PAGE_VISIBILITY_STATE', document[hidden]);
    }, false);
  }
  handleChange(state) {
    if (!state) {
      if (isApp) {
        setAppTitleColor(this.pageData.props.titleBgColor);
      }
    }
  }
  modfiTabsStyle() {
    const tabsEle = document.querySelector('.tabs');
    // console.log('tabsEle', tabsEle);
    if (tabsEle) {
      const gridItemEle = tabsEle?.parentNode;
      // console.log('gridItemEle', gridItemEle, gridItemEle?.classList);
      if (gridItemEle?.classList.contains('vue-grid-item')) {
        // 处理transform
        if (gridItemEle.classList.contains('del_transform')) {
          gridItemEle.classList.remove('del_transform');
        }
        const transform = getStyle(gridItemEle, 'transform');
        if (transform && transform.length && transform !== 'none') {
          const transformY = transform.split('(')[1].split(')')[0].split(',')[5];
          gridItemEle.style.top = `${transformY}px`;
          gridItemEle.className += ' del_transform';
        }
        // 处理backgroundColor
        const activityEle = document.querySelector('.activity');
        const activityBgColor = getStyle(activityEle, 'backgroundColor');
        const gridItemEleBgColor = getStyle(gridItemEle, 'backgroundColor');
        const gridItemEleBgImg = getStyle(gridItemEle, 'backgroundImage');
        const gridItemEleBgRepeat = getStyle(gridItemEle, 'backgroundRepeat') || 'no-repeat';
        const gridItemEleBgSize = getStyle(gridItemEle, 'backgroundSize') || 'auto';
        const crTabs = tabsEle.childNodes[0];
        crTabs.style.backgroundColor = activityBgColor;
        const stickyEle = crTabs?.childNodes[0];
        if (stickyEle?.classList.contains('cr-sticky') && stickyEle?.childNodes) {
          stickyEle.childNodes[0]?.style.backgroundColor = gridItemEleBgColor === 'rgba(0, 0, 0, 0)' ? activityBgColor : gridItemEleBgColor;
          // polyfill backgroundImage
          if (gridItemEleBgImg) {
            stickyEle.childNodes[0]?.style.backgroundImage = gridItemEleBgImg;
            stickyEle.childNodes[0]?.style.backgroundSize = gridItemEleBgSize;
            stickyEle.childNodes[0]?.style.backgroundRepeat = gridItemEleBgRepeat;
          }
        }
      }
    }
  }
  // 添加或修改url中的参数
  addOrEditUrlParams(url, paramName, replaceWith) {
    if (url.indexOf(paramName) > -1) {
      const re = new RegExp(paramName + '=[^&]*', 'gi');
      return url.replace(re, paramName + '=' + replaceWith);
    } else {
      const paraStr = paramName + '=' + replaceWith;
      const idx = url.indexOf('?');
      if (idx < 0) {
        url += '?';
      } else if (idx >= 0 && idx !== url.length - 1) {
        url += '&';
      }
      url = url + paraStr;
    }
    return url;
  }
  handleNavUrl(nav, isCurrent) {
    if (isCurrent) { return; }
    const token = localStorage.get('vccToken') || '';
    console.log(token, 'token');
    // 用于传递新橙参数，避免新橙H5活动中含有遮罩层
    const { vccChannel, fromHost } = this.$route.query;
    const { pageType, pageUrl } = nav;
    console.log(isApp, isWxMp, pageType);
    let nativeBridge;
    let mpBridge;
    if (+pageType === 1) { // 功能页面
      if (pageUrl === 'home') {
        if (isApp) {
          nativeBridge = new Bridge();
          nativeBridge.openNewUrl({
            data: {
              // 需要打开的新链接
              newUrl: home.app,
            },
          });
        } else if (isWxMp) {
          mpBridge = new MpBridge();
          const jumpConfig = {
            // 需要打开的新链接
            newUrl: home.wxmp,
            type: 'switchTab'
          };
          mpBridge.openNewUrl(jumpConfig);
        } else {
          let url = home.h5;
          if (vccChannel) { url = this.addOrEditUrlParams(url, 'vccChannel', vccChannel); }
          if (fromHost) { url = this.addOrEditUrlParams(url, 'fromHost', fromHost); }
          if (token) { url = this.addOrEditUrlParams(url, 'vccToken', token); }
          console.log(url, 1);
          window.location.href = url;
        }
      }
      if (pageUrl === 'shopcart') {
        if (isApp) {
          nativeBridge = new Bridge();
          nativeBridge.openNewUrl({
            data: {
              // 需要打开的新链接
              newUrl: shopcart.app,
            },
          });
        } else if (isWxMp) {
          mpBridge = new MpBridge();
          const jumpConfig = {
            // 需要打开的新链接
            newUrl: shopcart.wxmp,
            type: 'switchTab'
          };
          mpBridge.openNewUrl(jumpConfig);
        } else {
          let url = shopcart.h5;
          if (vccChannel) { url = this.addOrEditUrlParams(url, 'vccChannel', vccChannel); }
          if (fromHost) { url = this.addOrEditUrlParams(url, 'fromHost', fromHost); }
          if (token) { url = this.addOrEditUrlParams(url, 'vccToken', token); }
          console.log(url, 2);
          window.location.href = url;
        }
      }
      if (pageUrl === 'user') {
        if (isApp) {
          nativeBridge = new Bridge();
          nativeBridge.openNewUrl({
            data: {
              // 需要打开的新链接
              newUrl: user.app,
            },
          });
        } else if (isWxMp) {
          mpBridge = new MpBridge();
          const jumpConfig = {
            // 需要打开的新链接
            newUrl: user.wxmp,
            type: 'switchTab'
          };
          mpBridge.openNewUrl(jumpConfig);
        } else {
          let url = user.h5;
          if (vccChannel) { url = this.addOrEditUrlParams(url, 'vccChannel', vccChannel); }
          if (fromHost) { url = this.addOrEditUrlParams(url, 'fromHost', fromHost); }
          if (token) { url = this.addOrEditUrlParams(url, 'vccToken', token); }
          console.log(url, 3);
          window.location.href = url;
        }
      }
      return;
    } else {
      let url = pageUrl;
      if (!isApp && !isWxMp) {
        if (vccChannel) { url = this.addOrEditUrlParams(url, 'vccChannel', vccChannel); }
        if (fromHost) { url = this.addOrEditUrlParams(url, 'fromHost', fromHost); }
      }
      if (token) { url = this.addOrEditUrlParams(url, 'vccToken', token); }
      console.log(url, 5);
      window.location.href = url;
    }
  }
    // if (isApp) {
        // nativeBridge = new Bridge();
        // nativeBridge.openNewUrl({
        //   data: {
        //     // 需要打开的新链接
        //     newUrl: `xyqb://openHttp?jumpUrl=${pageUrl}`
        //   },
        // });
        // window.location.href = pageUrl;
        // nativeBridge = null;
      // } else if (isWxMp) {
        // mpBridge = new MpBridge();
        // const jumpConfig = {
        //     // 需要打开的新链接
        //   newUrl: pageUrl
        // };
        // mpBridge.openNewUrl(jumpConfig);
        // mpBridge = null;
      //   window.location.href = pageUrl;
      // } else {
      //   if (vccChannel) { url = this.addOrEditUrlParams(url, 'vccChannel', vccChannel); }
      //   if (fromHost) { url = this.addOrEditUrlParams(url, 'fromHost', fromHost); }
      //   window.location.href = url;
      // }
