import http from '../service/http.service';
import config from '../config';

export default {
  getPageById(params) {
    return http.get(`${config.apiHost}/editor/get/${params.pageId}?lite=1`);
  },
  getShopCartCount() {
    return http.get(`${config.kdspHost}/api/kdsp/shop-cart/count`);
  },
  getMpSchema(params) {
    return http.post(`${config.kdspHost}/api/kdsp/ka/info/getShareMiniUrl`, params, { emulateJSON: true });
  },
  getWxConfig(url = window.location.href.split('#')[0]) {
    return http.post(`${config.kdspHost}/api/kdsp/wx/mp/getJsapiSign`, {
      url,
      appId: 'wx2f44c7fe7b08458d'
    });
  }
};