// tslint:disable
import { errorQueryValues } from './utils.service';
const cookies = require('js-cookie');
const option = {
  domain: EASY_ENV_IS_BROWSER && window.location.host.indexOf('.q-gp.com') >= 0 ? '.q-gp.com' : '',
  expires: 365,
};
const Cookies = {
  get(key) {
    let result = cookies.get(key) || '';
    if (errorQueryValues.indexOf(result) > -1) result = '';
    try {
      return JSON.parse(result);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    return cookies.set(key, value, option);
  },
  clear() {
    return Object.keys(cookies.get()).forEach(function(cookie) {
      Cookies.remove(cookie, option);
    });
  },
  remove(key) {
    return cookies.remove(key, option);
  },
};

module.exports = Cookies;
