const COS = require('cos-nodejs-sdk-v5');
const path = require('path');
const fs = require('fs');

const prefix = process.env.NODE_ENV === 'production' ? 'qb' : 'qb-test';
const cdnPrefix = `https://misc.lkbang.net/${prefix}/`;

class upload2Cos {
  filesPath = [];
  instance = null;

  constructor() {
    this.filesPath = [];
    this.instance = new COS({
        SecretId: 'AKIDVlxtVqOK9i0wc0m0e7C5saATZnl2xvUx',
        SecretKey: 'NWQ3VlmWeFtIQHrDI6F9oCheMq41lGVV'
    });
  }

  getFilesPath() {
    this._readFileList(path.resolve(__dirname, './public'), this.filesPath);
  }

  upload() {
    this.getFilesPath();
    const filesList = this.filesPath.map(filepath => {
      return {
        Bucket: 'misc-1258270469',
        Region: 'ap-beijing',
        Key: `${prefix}/public${filepath.split('public')[1]}`,
        FilePath: filepath
      }
    });

    this.instance.uploadFiles({
       files: filesList,
       SliceSize: 1024 * 1024,
       onProgress: function (info) {
           var percent = parseInt(info.percent * 10000) / 100;
           var speed = parseInt(info.speed / 1024 / 1024 * 100) / 100;
           console.log('进度：' + percent + '%; 速度：' + speed + 'Mb/s;');
       },
       onFileFinish: function (err, data, options) {
           console.log(options.Key + '上传' + (err ? '失败' : '完成'));
       },
    }, function (err, data) {
       console.log(err || data);
    });
  }

  _isValid (path) {
    const format = ['.ico', '.html'];
    return !format.some(v => path.endsWith(v)) 
  }

  _readFileList(dir, filesPath = []) {
    const files = fs.readdirSync(dir);
    files.forEach((item, index) => {
      var fullPath = path.join(dir, item);
      const stat = fs.statSync(fullPath);
      if (stat.isDirectory()) {   
        this._readFileList(path.join(dir, item), filesPath);
      } else if(this._isValid(fullPath)) {        
        filesPath.push(fullPath);           
      }    
    });
    return filesPath;
  }
}

module.exports = {
  upload2Cos,
  cdnPrefix
};