// tslint:disable
import { errorQueryValues } from './utils.service';

export default {
  get(key) {
    let result = EASY_ENV_IS_BROWSER && window.localStorage.getItem(key);
    if (errorQueryValues.indexOf(result) > -1) result = '';
    try {
      return JSON.parse(result as string);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    if (value === undefined) { return; }
    const toString = Object.prototype.toString;
    if (toString.call(value) === '[object Array]' || toString.call(value) === '[object Object]') {
      value = JSON.stringify(value);
    }

    return EASY_ENV_IS_BROWSER && window.localStorage.setItem(key, value);
  },
  remove(key) {
    return EASY_ENV_IS_BROWSER && window.localStorage.removeItem(key);
  },
  clear() {
    return EASY_ENV_IS_BROWSER && window.localStorage.clear();
  }
};
