import http from '../service/http.service';
import config from '../config';

export default {
  getPageById(params) {
    return http.get(`${config.apiHost}/editor/get/${params.pageId}?lite=1`);
  },
  getShopCartCount() {
    return http.get(`${config.kdspHost}/api/kdsp/shop-cart/count`);
  },
  getMpSchema(params, appId, tenantId) {
    return http.post(`${config.kdspHost}/api/kdsp/ka/info/getShareMiniUrl`, params, {
      emulateJSON: true,
      hideToast: true,
      headers: {
        'mini-app-id': appId,
        'qg-tenant-id': tenantId
      }
    });
  },
  getWxConfig(url = window.location.href.split('#')[0]) {
    return http.post(`${config.kdspHost}/api/kdsp/wx/mp/getJsapiSign`, {
      url,
      appId: 'wx2f44c7fe7b08458d',
      hideLoading: true
    });
  },
  getFinanceSetting(appChannel) {
    const customHeader: any = {};
    if (EASY_ENV_IS_BROWSER) {
      const ua = window.navigator.userAgent;
      const appVersion = ua.match(/xyqb\/([\d|.]+)/) ? (ua.match(/xyqb\/([\d|.]+)/) as string[])[1] : '8.2.00';
      customHeader.version = appVersion;
      if (appChannel) {
        customHeader.appChannel = appChannel;
      }
    }

    // return http.post(`http://yapi.quantgroups.com/mock/351/api/kdsp/api/kdsp/vcc_switch`, {
    return http.post(`${config.kdspHost}/api/kdsp/vcc_switch/get-vcc-status`, {
      areaType: 6
    }, {
      customHeader
    });
  },
  getServerTime() {
    return http.get(`${config.apiHost}/editor/getServerTime`);
  },

  getTongDunIdByKey(params) {
    return http.post(`${config.kdspHost}/api/kdsp/fraud/getDeviceId`, params);
  },
};