import http from '../service/http.service';
import config from '../config';

export default {
  getPageById(params) {
    return http.get(`${config.apiHost}/editor/get/${params.pageId}?lite=1`);
  },
  getShopCartCount() {
    return http.get(`${config.kdspHost}/api/kdsp/shop-cart/count`);
  },
  getMpSchema(params, appId, tenantId) {
    return http.post(`${config.kdspHost}/api/kdsp/ka/info/getShareMiniUrl`, params, {
      emulateJSON: true,
      hideToast: true,
      headers: {
        'mini-app-id': appId,
        'qg-tenant-id': tenantId
      }
    });
  },
  getWxConfig(url = window.location.href.split('#')[0]) {
    return http.post(`${config.kdspHost}/api/kdsp/wx/mp/getJsapiSign`, {
      url,
      appId: 'wx2f44c7fe7b08458d',
      hideLoading: true
    });
  },
  getFinanceSetting() {
    // return http.post(`http://yapi.quantgroups.com/mock/351/api/kdsp/api/kdsp/vcc_switch`, {
    return http.post(`${config.kdspHost}/api/kdsp/vcc_switch/get-vcc-status`, {
      areaType: 11
    });
  }
};