import { EggAppConfig } from 'egg';
import * as fs from 'fs';
import * as path from 'path';
import wxVertify from './wxVertify';
const { redis, api, qiniu } = require(path.resolve(__dirname, './apollo.json'));

export default (appInfo: EggAppConfig) => {
  const config: any = {};

  const siteFile = wxVertify;
  siteFile['/favicon.ico'] = fs.readFileSync(path.join(appInfo.baseDir, 'app/web/asset/images/favicon.ico'));
  config.siteFile = siteFile;

  config.view = {
    cache: false
  };

  config.vuessr = {
    layout: path.resolve(appInfo.baseDir, 'app/web/view/layout.html'),
    renderOptions: {
      basedir: path.join(appInfo.baseDir, 'app/view'),
    },
  };

  config.logger = {
    outputJSON: true,
    consoleLevel: 'DEBUG',
    dir: path.join(appInfo.baseDir, 'logs')
  };

  config.static = {
    prefix: '/public/',
    dir: path.join(appInfo.baseDir, 'public'),
    gzip: true
  };

  config.keys = '123456';

  config.middleware = [
    'access'
  ];

  config.cors = {
    origin: '*',
    allowMethods: 'GET,HEAD,PUT,POST,DELETE,PATCH'
  };
  config.security = {
    xframe: {
      enable: false
    }
  };
  config.redis = {
    client: redis
  };
  config.apollo = {
    ...api, ...qiniu
  };
  return config;
};
