interface Schame {
  key: string;
  name: string;
  type: string;
}

interface Point {
  x: number;
  y: number;
  w: number;
  h: number;
  i: number | string;
  responsive: boolean; // 自定义属性, 表示是否根据背景图片调整宽高
}

interface CommonStyle {
  left: number;
  top: number;
}

interface GridLayout {
  draggable: boolean;
  rowHeight: number;
}

export interface PageElement {
  name: string;
  title: string;
  schame: Schame[];
  props: object;
  point: Point;
  commonStyle: CommonStyle;
  child: PageElement[];
}

export interface Page {
  commonStyle: CommonStyle;
  props: object;
  elements: PageElement[];
}

export interface PageInfo {
  id?: number;
  page?: Page | string;
  enable?: number;
  author?: string;
  coverImage?: string;
  isTemplate?: number;
  isPublish?: number | boolean;
}

export const defaultState = {
  noPageData: false,
  curChildIndex: null,
  pageInfo: {
    id: 0,
    pageName: '',
    pageDescribe: '',
    coverImage: 'http://activitystatic.q-gp.com/low_code.jpg',
    isPublish: false,
    page: {
      commonStyle: {
        backgroundColor: '#f7f8fa',
        backgroundImage: ''
      },
      props: {
        showPageBottomTip: true,
        pageBottomTxt: '没有更多啦～',
        pageBottomColor: '#fff',
        showBackTop: true,
        btAttachVal: [
          {
            name: '购物车',
            icon: 'shopping-cart-o',
            url: 'xyqb://shoppingCartTab',
            color: '#333',
            background: '#fff'
          }
        ],
      },
      elements: [],
    }
  },
  templateList: [],
  gridLayout: {
    draggable: true,
    rowHeight: 1,
    colNum: 375
  },
};

export default interface EditorState {
  pageInfo: PageInfo;
  draggable: boolean;
  noPageData: boolean;
  curChildIndex: number | null;
  templateList: any[];
  rowHeight: number;
  gridLayout: GridLayout;
}