import apolloSsr from '../../../config/apollo.ssr.json';
const protocol = EASY_ENV_IS_BROWSER ? window.location.protocol : 'https:';

const hostMap = {
  apiHost: `${protocol}//quantum-blocks-test1.liangkebang.net`,
  talosHost: `${protocol}//talos-test1.liangkebang.net`,
  kdspHost: `${protocol}//kdsp-api-test1.liangkebang.net`,
  shenceUrl: `${protocol}//bn.xyqb.com/sa?project=default`,
  mallHost: `${protocol}//mall-test1.liangkebang.net`,
  xyqbH5Host: `${protocol}//mapi-test1.liangkebang.net`,
  test: true,
  yxmTenantId: 560761,
  appIdMap: {
    560761: 'wxe16bf9293671506c',
    560867: 'wxccb8435d68e8c7d6',
  },
};

if (EASY_ENV_IS_BROWSER) {
  const apolloWin = window.apollo || window.__INITIAL_STATE__.apollo;
  if (apolloWin) {
    for (const key in apolloWin) {
      if (apolloWin[key]) {
        hostMap[key] = apolloWin[key];
      }
    }
  }
}
if (EASY_ENV_IS_NODE) {
  if (apolloSsr) {
    for (const key in apolloSsr) {
      if (apolloSsr[key]) {
        hostMap[key] = apolloSsr[key];
      }
    }
  }
}

export default hostMap;
