import { Vue, Component, Prop } from 'vue-property-decorator';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import { release } from '@/.sentryclirc';
import '@/service/qg.service';

// 初始化sentry
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('http://0785298052fd46128e201f30ca649102@sentry.q-gp.com/64', {
    release,
    environment: 'production'
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

@Component({
  name: 'Layout'
})
export default class Layout extends Vue {
  @Prop({ type: String, default: 'egg' }) title?: string;
  @Prop({ type: String, default: 'Vue TypeScript Framework, Server Side Render' }) description?: string;
  @Prop({ type: String, default: 'Vue,TypeScript,Isomorphic' }) keywords?: string;

  isNode: boolean = EASY_ENV_IS_NODE;
  // saSrc: string = `<script src="https://activitystatic.lkbang.net/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`;
  // swiperSrc: string = `<script src="https://activitystatic.lkbang.net/swiper/4.5.1/swiper.min.js"></script>`;
  // vueSrc: string = `<script src="https://activitystatic.lkbang.net/vue/2.6.11/vue.min.js"></script>`;
  // vueRouterSrc: string = `<script src="https://activitystatic.lkbang.net/vue-router/3.2.0/vue-router.min.js"></script>`;
  // vuexSrc: string = `<script src="https://activitystatic.lkbang.net/vuex/3.4.0/vuex.min.js"></script>`;
  scriptSrc: string[] = [
    // `<script src="https://activitystatic.lkbang.net/vue/2.6.11/vue.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vue-router/3.2.0/vue-router.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/vuex/3.4.0/vuex.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/swiper/4.5.1/swiper.min.js"></script>`,
    `<script src="https://cdn.bootcss.com/axios/0.19.2/axios.min.js"></script>`
  ];

  created() {
    console.log('>>EASY_ENV_IS_NODE create', EASY_ENV_IS_NODE);
  }
}