import { Vue, Component, Watch, Provide, Mixins } from 'vue-property-decorator';
import FreedomContainer from '../../component/FreedomContainer/index.vue';
import GridLayout from '../../component/VueGridLayout/GridLayout.vue';
import GridItem from '../../component/VueGridLayout/GridItem.vue';
// import LoginForm from '@/lib/Form/index.vue';
import DownloadGuide from '@/lib/DownloadGuide/index.vue';
import { Getter, State, Mutation } from 'vuex-class';
import GuideCube from '@/lib/GuideCube/index.vue';
import GoodsTabs from '@/lib/GoodsTabs/index.vue';
import Coupon from '@/lib/Coupon/index.vue';
import Advertisement from '@/lib/Advertisement/index.vue';
import TransformStyleMixin from '@/page/mixins/transformStyle.mixin';
import { getStyle } from '@/service/utils.service';

@Component({ components: { FreedomContainer, GridLayout, GridItem, DownloadGuide, GoodsTabs, GuideCube, Advertisement, Coupon }, name: 'Activity'})
export default class Activity extends Mixins(TransformStyleMixin) {
  @Getter('pageData') pageData;
  @State(state => state.editor.pageInfo.pageName) pageName;
  @State(state => state.editor.gridLayout.rowHeight) rowHeight;

  @Provide('editor');

  isLayoutComReady = false;
  showBackTop = false;
  targetEle: HTMLElement | null = null;

  get layout() {
    return this.pageData && this.pageData.elements.map(v => v.point) || [];
  }

  @Watch('pageName', { immediate: true })
  onPageNameChange(newVal) {
    if (EASY_ENV_IS_BROWSER && newVal) {
      document.title = newVal;
      // 如果是 iOS 设备，则使用如下 hack 的写法实现页面标题的更新
      if (navigator.userAgent.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/)) {
        const hackIframe = document.createElement('iframe');
        hackIframe.style.display = 'none';
        hackIframe.src = '/public/fixIosTitle.html?r=' + Math.random();
        document.body.appendChild(hackIframe);
        setTimeout(() => {
          document.body.removeChild(hackIframe);
        }, 300);
      }
    }
  }

  mounted() {
    this.targetEle = document.querySelector('body');
    this.showBackTop = true;
    const timer = setTimeout(() => {
      this.modfiTabsStyle();
    }, 500);
    this.$once('hook:beforeDestroy', () => {
      clearTimeout(timer);
    });
  }

  fetchApi(options) {
    const { store, route } = options;
    const { pageId } = route.params;
    console.log('fetchApi', route);
    return store.dispatch('getPageDate', { pageId });
  }

  createStyle({h}) {
    return EASY_ENV_IS_NODE ? {
      height: `${h * this.rowHeight}px`,
    } : {};
  }

  modfiTabsStyle() {
    const tabsEle = document.querySelector('.tabs');
    if (tabsEle) {
      const gridItemEle = tabsEle?.parentNode;
      if (gridItemEle?.classList.contains('vue-grid-item')) {
        // 处理transform
        const transform = getStyle(gridItemEle, 'transform');
        const transformY = transform.split('(')[1].split(')')[0].split(',')[5];
        gridItemEle.style.transform = 'none';
        gridItemEle.style.top = `${transformY}px`;
        // 处理backgroundColor
        const backgroundColor = getStyle(tabsEle, 'backgroundColor');
        const crTabs = tabsEle.childNodes[0];
        crTabs.style.backgroundColor = backgroundColor;
        const stickyEle = crTabs?.childNodes[0];
        if (stickyEle?.classList.contains('cr-sticky') && stickyEle?.childNodes) {
          stickyEle.childNodes[0]?.style.backgroundColor = backgroundColor;
        }
      }
    }
  }
}