import 'intersection-observer';

export default class Exposure {
  observer;

  constructor() {
    this.init();
  }

  init() {
    this.observer = new IntersectionObserver((entries, observer) => {
      entries.forEach(entry => {
        if (entry.isIntersecting) {
          this.dot(entry?.target?.attributes?.['data-dot']?.value);
        }
      });
    });

  }

  add(entry) {
    if (this.observer) { this.observer.observe(entry.el); }
  }

  dot(title) {
    console.log(title, '进入了');
  }
}