import { Vue, Component, Prop } from 'vue-property-decorator';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import { release } from '@/.sentryclirc';
import '@/service/qg.service';

// 初始化sentry
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('http://0785298052fd46128e201f30ca649102@sentry.q-gp.com/64', {
    release,
    environment: 'production'
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

@Component({
  name: 'Layout'
})
export default class Layout extends Vue {
  @Prop({ type: String, default: 'egg' }) title?: string;
  @Prop({ type: String, default: 'Vue TypeScript Framework, Server Side Render' }) description?: string;
  @Prop({ type: String, default: 'Vue,TypeScript,Isomorphic' }) keywords?: string;

  isNode: boolean = EASY_ENV_IS_NODE;
  scriptSrc: string = `<script src="https://activitystatic.lkbang.net/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`;

  created() {
    console.log('>>EASY_ENV_IS_NODE create', EASY_ENV_IS_NODE);
  }
}