import Vue from 'vue';
import sa from 'sa-sdk-javascript';
import config from '@/config';
import Storage from '@/service/localStorage.service';
import { getParameterByName, isWxMp, isApp } from '@/service/utils.service';

export function initSa(router) {
  console.log('initSa', EASY_ENV_IS_BROWSER, config, window.location.pathname);
  const activityId = window.location.pathname.split('/')?.[2] || '';
  const vccChannel = getParameterByName('vccChannel') || getParameterByName('registerFrom');
  const sonVccChannel = getParameterByName('sonVccChannel');
  sa.init({
    server_url: config.shenceUrl,
    heatmap: {
      // 是否开启点击图，默认 default 表示开启，自动采集 $WebClick 事件，可以设置 'not_collect' 表示关闭
      clickmap: 'not_collect',
      // 是否开启触达注意力图，默认 default 表示开启，自动采集 $WebStay 事件，可以设置 'not_collect' 表示关闭
      scroll_notice_map: 'default',
    },
    // 判断外层是否有 App 的 SDK ，如果有的话，会往 App 的 SDK 发数据。如果没有，就正常发送数据。
    use_app_track: true,
    show_log: config.test,
    app_js_bridge: true,
  });
  // 添加公共属性
  sa.registerPage({
    platformType: isWxMp ? 'MP' : isApp ? 'APP' : 'H5',
    activity_id: activityId,
    parent_channel_id: vccChannel || '',
    channel_id: sonVccChannel || ''
  });
  router.afterEach(() => {
    Vue.nextTick(() => {
      sa.quick('autoTrackSinglePage');
    });
  });
}

export function registeredEvents(eventName, eventData) {
  sa.track(eventName, eventData);
}
// 用户登录神策埋点
export function loginSa(uuid = Storage.get('uuid')) {
  if (!uuid) { return; }
  Storage.set('uuid', uuid);
  sa.login(uuid);
}
