// const protocol = EASY_ENV_IS_BROWSER ? window.location.protocol : 'https';
import apolloSsr from '../../../config/apollo.ssr.json';
const protocol = EASY_ENV_IS_BROWSER ? window.location.protocol : 'https:';

const hostMap = {
  apiHost: `${protocol}//quantum-blocks.q-gp.com`,
  talosHost: `${protocol}//talos.q-gp.com`,
  kdspHost: `${protocol}//kdsp-api.q-gp.com`,
  shenceUrl: `${protocol}//bn.xyqb.com/sa?project=production`,
  mallHost: `${protocol}//mall.q-gp.com`,
  h5MallHost: `${protocol}//saas.q-gp.com`,
  xyqbH5Host: `${protocol}//h5-api.q-gp.com`,
  test: false,
  yxmTenantId: 560761,
  appIdMap: {
    560761: 'wxb3e6270e1b1e0bc7',
    560867: 'wxbd0bc68b270a1dab',
  },
};

if (EASY_ENV_IS_BROWSER) {
  const apolloWin = window.apollo || window.__INITIAL_STATE__.apollo;
  if (apolloWin) {
    for (const key in apolloWin) {
      if (apolloWin[key]) {
        hostMap[key] = apolloWin[key];
      }
    }
  }
}
if (EASY_ENV_IS_NODE) {
  if (apolloSsr) {
    for (const key in apolloSsr) {
      if (apolloSsr[key]) {
        hostMap[key] = apolloSsr[key];
      }
    }
  }
}
export default hostMap;
