// tslint:disable
import { isAndroid, isIOS, isWxMp, isApp } from '@/service/utils.service';
import localStorage from '@/service/localStorage.service';
import Toast from '@qg/cherry-ui/src/toast';

function getURLSearchParams(json) {
  if (!json) return '';
  const dataArray = Object.keys(json).map(key => {
    if (json[key] === undefined) return '';
    return encodeURIComponent(key) + '=' + encodeURIComponent(json[key]);
  });
  return dataArray.filter(item => item !== undefined && item !== null).join('&');
}

function getVccChannel(channelKey = 'vccChannel') {
  const localChannel = localStorage.get(channelKey) || '';
  if (channelKey === 'sonVccChannel') {
    return localChannel;
  }
  return localChannel
    ? localChannel
    : isWxMp
    ? '159913'
    : isAndroid
    ? '217'
    : isIOS
    ? '214'
    : '';
}
export default {
  service: {
    response(res) {
      const { data, config } = res;
      // api需要返回原始响应
      const returnRawData = config.rawData;
      if (returnRawData) return [data, null];

      const success =
        (data.code === 0 && data.business_code === 0) ||
        (data.code === '0000' && data.businessCode === '0000');
      // 业务完成，返回有效载荷
      if (success) {
        return [data.data, null];
      }
      // 接下来处理异常业务
      const msg = data.msg || '服务异常';

      if (!config.hideToast || !data.noAlert) {
        Toast(msg);
      }
      // 给用户提示信息，明确发生错误
      // 请求参数和响应数据都可以控制不提示
      const error = new Error(msg);
      error.response = data;
      console.error(error);
      // 业务代码可以根据response进行再处理
      return [null, error];
    },
    request(cfg) {
      const { method, hideVccChannel } = cfg;
      cfg.headers['qg-tenant-id'] = localStorage.get('tenantId') || '';
      cfg.headers['X-Auth-Token'] = localStorage.get('vccToken') || '';
      cfg.headers['version'] = '8.2.00';
      if (cfg.customHeader) {
        Object.assign(cfg.headers, cfg.customHeader);
      }
      if (cfg.creditToken) {
        cfg.headers['X-Auth-Token'] = localStorage.get('creditToken');
      }
      if (!cfg.hideTerminal) {
        let terminal = '';
        if (isApp) {
          terminal = isAndroid ? 'ANDROID' : 'IOS';
        } else if (isWxMp) {
          terminal = 'MINI-APP';
        } else if (
          window.__INITIAL_STATE__.isEditor &&
          cfg.hideTerminalInEditor
        ) {
          terminal = '';
        } else {
          terminal = 'H5';
        }
        cfg.headers['x-user-terminal'] = terminal;
      }
      if (!hideVccChannel) {
        cfg.headers['vccChannel'] = getVccChannel();
        cfg.headers['sonVccChannel'] = getVccChannel('sonVccChannel');
      }
      if (method === 'post' && cfg.emulateJSON) {
        cfg.headers['Content-Type'] = 'application/x-www-form-urlencoded';
        cfg.data = getURLSearchParams(cfg.data);
      }
      return cfg;
    }
  }
};
