import { Component, Prop, Vue, Mixins } from 'vue-property-decorator';
import { Action, Mutation, State, Getter } from 'vuex-class';
import TransformStyleMixin from '@/page/mixins/transformStyle.mixin';
import SaMixin from '@/page/mixins/sa.mixin';
// import { resizeDiv } from '@/service/utils.service';
import { locationHrefPatchDelay, getTokenFromApp } from '@qg/citrus-ui/src/helper/service/utils';
import saTrackMixins from '@qg/citrus-ui/src/helper/mixins/saTrack.mixins';

@Component({ name: 'FreedomContainer' })
export default class FreedomContainer extends Mixins(TransformStyleMixin, SaMixin, saTrackMixins) {
  @Getter('pageData') pageData;
  @State(state => state.activity.curChildIndex) curChildIndex;
  showVideo = false;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;
  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop({type: Object, default: () => ({})}) saInfo;
  @Prop(String) link;
  @Prop(String) backgroundImage;

  clickEvent() {
    console.log(this.childItem);
    let needLogin = false;
    try {
      needLogin = this.childItem.props.needLogin;
    } catch (err) {
      console.log(err);
    }
    if (needLogin) {
      getTokenFromApp().then(hasLogin => {
        if (hasLogin) {
          locationHrefPatchDelay(this.link);
        }
      });
    } else {
      console.log(this.link);
      locationHrefPatchDelay(this.link);
    }
  }

  mounted() {
    this.showVideo = true;
    // 根据背景图设置元素高度
    // const index = this.pageData?.elements?.findIndex(v => v.point?.responsive);
    // const { props: { backgroundImage }, point } = this.pageData?.elements[index] || { props: {}};
    // if (backgroundImage) {
    //   resizeDiv(backgroundImage, null, null, (height) => {
    //     this.updatePageInfo({ containerIndex: index, data: { ...this.pageData?.elements[index], point: { ...point, h: height ?? point.h } } });
    //   });
    // }
  }

}
