'use strict';
const path = require('path');
const SentryPlugin = require("webpack-sentry-plugin");
const resolve = filepath => path.resolve(__dirname, filepath);
const SentryConfig = require("./app/web/.sentryclirc.ts");

module.exports = {
  entry: {
    // 'login': 'app/web/page/login/index.vue',
    // 'editor': 'app/web/page/editor/index.ts',
    'activity': 'app/web/page/activity/index.ts',
  },
  resolve: {
    alias:{
      '@': resolve('app/web'),
      '@api': resolve('app/web/api'),
      '@asset': resolve('app/web/asset'),
      '@framework': resolve('app/web/framework'),
      '@component': resolve('app/web/component'),
      '@store': resolve('app/web/page/store'),    
      // '@router': resolve('app/web/page/admin/home/router'),        
      // '@view': resolve('app/web/page/admin/home/view'),
      // '@editor': resolve('app/web/page/editor')
    }
  },
  nodeExternals: {
    whitelist: [ moduleName => { 
      return /cherry-ui/.test(moduleName) || /citrus-ui/.test(moduleName) || /@interactjs/.test(moduleName);
    }] 
  },
  module:{
    rules:[
      { babel: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui'), resolve('node_modules/@interactjs'), resolve('node_modules/@qg/citrus-ui')],
          exclude: []
        } 
      },
      {
        vue: {
          include: [resolve('app/web'), resolve('node_modules/@qg/cherry-ui'), resolve('node_modules/@qg/citrus-ui')],
          exclude: []
        }
      },
      { ts: true },
      {  less: true },
      { tslint: { options: { fix: true } } },
    ]
  },
  plugins: [
    {
      copy: [{
        from: 'app/web/asset',
        to: 'asset'
      }]
    },
    { imagemini: false },
    {
      sentry: {
        env: ['prod'],
        name: 'webpack-sentry-plugin',
        args: SentryConfig
      }
    },
    {
      define:{
        'process.env': {
           SENTRY_ENV: JSON.stringify(process.env.SENTRY_ENV)
        }
      }
    }
  ],
  optimization: {
    namedModules: true,
    namedChunks: true,
    runtimeChunk: { 
      name: 'runtime' 
    },
    splitChunks:
    {
      name: false,
      chunks: 'all',
      cacheGroups:
      {
        default: false,
        vue: {
          name: 'vue', // 分离组件库
          priority: 23,
          test: /[\\/]node_modules[\\/]vue[\\/]/,
          enforce: true
        },
        vueRouter: {
          name: 'vue-router',
          priority: 23,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]vue-router[\\/]/,
          enforce: true
        },
        vuex: {
          name: 'vuex', // 分离组件库
          priority: 23,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]vuex[\\/]/,
          enforce: true
        },
        interactjs: {
          name: 'interactjs', // 分离组件库
          priority: 21,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]@interactjs[\\/]/,
          enforce: true
        },
        elementResizeDetector: {
          name: 'element-resize-detector', // 分离组件库
          priority: 20,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]element-resize-detector[\\/]/,
          enforce: true
        },
        ravenJs: {
          name: 'raven-js', // 分离组件库
          priority: 19,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]raven-js[\\/]/,
          enforce: true
        },
        cherryUI: {
          name: 'cherry-uI', // 分离组件库
          priority: 18,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]@qg[\\/]cherry-ui[\\/]/,
          enforce: true
        },
        citrusUi: {
          name: 'citrus-ui', // 分离组件库
          priority: 17,
          chunks: 'all',
          test: /[\\/]node_modules[\\/]@qg[\\/]citrus-ui[\\/]/,
          enforce: true
        },
        vendors:
        {
          name: 'common',
          chunks: 'all',
          minChunks: 3,
          priority: 2,
          test: /node_modules/,
          reuseExistingChunk: true
        },
        styles:
        {
          name: 'common',
          chunks: 'all',
          minChunks: 3,
          priority: 1,
          test: /\.(css|less|scss|stylus)$/,
          priority: 50,
        }
      }
    }
  },
  externals: {
    // 'vue': 'Vue',
    // 'vue-router': 'VueRouter',
    // 'vuex': 'Vuex',
    'axios': 'axios',
    'sa-sdk-javascript': 'sensorsDataAnalytic201505',
    'swiper': 'Swiper',
  },
  // mode: 'development',
  devtool:'source-map',
  customize(webpackConfig){
   // 此外 webpackConfig 为原生生成的 webpack config，可以进行自定义处理
   return webpackConfig;
  }
};