import { Component, Prop, Vue, Mixins } from 'vue-property-decorator';
import { Action, Mutation, State, Getter } from 'vuex-class';
import TransformStyleMixin from '@/page/mixins/transformStyle.mixin';
import CustomMarquee from '@/lib/Marquee/index.vue';
import { resizeDiv } from '@/service/utils.service';

@Component({ components: { CustomMarquee }, name: 'FreedomContainer' })
export default class FreedomContainer extends Mixins(TransformStyleMixin) {
  @Getter('pageData') pageData;
  @State(state => state.activity.curChildIndex) curChildIndex;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;

  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop(String) backgroundImage;

  mounted() {
    // 根据背景图设置元素高度
    const index = this.pageData?.elements?.findIndex(v => v.point?.responsive);
    const { props: { backgroundImage }, point } = this.pageData?.elements[index] || { props: {}};
    if (backgroundImage) {
      resizeDiv(backgroundImage, null, null, (height) => {
        this.updatePageInfo({ containerIndex: index, data: { ...this.pageData?.elements[index], point: { ...point, h: height ?? point.h } } });
      });
    }
  }
}