'use strict';
import Vue from 'vue';
import Vuex from 'vuex';
import RootState from './state';
import Activity from './modules/activity';

Vue.use(Vuex);

export default function createStore(initState: any = {}) {
  const { title, url, origin, locale, csrf, activity } = initState;
  const state = { title, url, origin, locale, csrf };
  return new Vuex.Store<RootState>({
    state,
    modules: {
      activity: new Activity(activity)
    }
  });
}