import { EggAppConfig } from 'egg';
import * as fs from 'fs';
import * as path from 'path';

export default (appInfo: EggAppConfig) => {
  const config: any = {};

  config.siteFile = {
    '/favicon.ico': fs.readFileSync(path.join(appInfo.baseDir, 'app/web/asset/images/favicon.ico')),
    '/FZz8NUb3x0.txt': fs.readFileSync(path.join(appInfo.baseDir, 'app/web/asset/FZz8NUb3x0.txt')),
    '/Ra6UCOeIhV.txt': fs.readFileSync(path.join(appInfo.baseDir, 'app/web/asset/Ra6UCOeIhV.txt'))
  };

  config.view = {
    cache: false
  };

  config.vuessr = {
    layout: path.resolve(appInfo.baseDir, 'app/web/view/layout.html'),
    renderOptions: {
      basedir: path.join(appInfo.baseDir, 'app/view'),
    },
  };

  config.logger = {
    outputJSON: true,
    consoleLevel: 'DEBUG',
    dir: path.join(appInfo.baseDir, 'logs')
  };

  config.static = {
    prefix: '/public/',
    dir: path.join(appInfo.baseDir, 'public'),
    gzip: true
  };

  config.keys = '123456';

  config.middleware = [
    'access'
  ];

  config.cors = {
    origin: '*',
    allowMethods: 'GET,HEAD,PUT,POST,DELETE,PATCH'
  };
  config.security = {
    xframe: {
      enable: false
    }
  };
  return config;
};
