import { Component, Vue } from 'vue-property-decorator';
import { transformStyle, getStyle } from '@/service/utils.service';
import { Mutation } from 'vuex-class';

@Component({ name: 'TransformStyleMixin' })
export default class TransformStyleMixin extends Vue {
  @Mutation('SET_ELEMENT_POINT') setElementPoint;

  transformStyle(styleObj, point = {}, name) {
    const style = {
      backgroundRepeat: 'no-repeat',
      backgroundSize: 'cover',
      backgroundPosition: 'center'
    };
    if (!styleObj) { return style; }
    for (const key of Object.keys(styleObj)) {
      if ( typeof styleObj[key] === 'number') {
        style[key] = `${(styleObj[key] / 37.5).toFixed(2)}rem`;
      } else {
        style[key] = styleObj[key]?.includes('px') ? `${(+(styleObj[key].slice(0, -2)) / 37.5).toFixed(2)}rem` : styleObj[key];
      }
      if (key === 'backgroundImage' && style.backgroundImage) {
        style.backgroundImage = `url(${style.backgroundImage})`;
      }
    }
    if (name === 'freedom-container' && point) {
      style.height = point?.h ? `${point.h}px` : null;
    }
    // style.zIndex = 2;
    return style;
  }

  adjustHeight(element) {
    if (!element) { return; }
    // 计算组件高度
    element.style.height = 'auto';
    const height = getStyle(element, 'height');
    element.style.height = '';
    // 修改对应组件point
    const eleId = element.getAttribute('id');
    const component = this.pageData.elements.find(v => v.id === eleId);
    if (!component) { return; }
    const calcHeight = +height + (component.commonStyle.paddingTop || 0) + (component.commonStyle.paddingBottom || 0);
    const point = { ...component.point, h: component.name === 'cs-goods-tabs' ? Math.floor(+calcHeight) : Math.ceil(+calcHeight) };
    this.setElementPoint({ id: eleId, data: point });
    // console.log('adjustHeight', height, component, element.getAttribute('id'), point);
  }
}
