import { Component, Vue } from 'vue-property-decorator';
import { transformStyle } from '@/service/utils.service';

@Component({ name: 'TransformStyleMixin' })
export default class TransformStyleMixin extends Vue {
  transformStyle(styleObj, element) {
    // console.log('transformStyle', styleObj, element);
    const style = {};
    if (!styleObj) { return style; }
    for (const key of Object.keys(styleObj)) {
      if ( typeof styleObj[key] === 'number') {
        style[key] = `${(styleObj[key] / 37.5).toFixed(2)}rem`;
      } else {
        style[key] = styleObj[key]?.includes('px') ? `${(+(styleObj[key].slice(0, -2)) / 37.5).toFixed(2)}rem` : styleObj[key];
      }
      if (key === 'backgroundImage' && style.backgroundImage) {
        // style.backgroundImage = `url(${style.backgroundImage})`;
        style.background = `url(${style.backgroundImage}) no-repeat 0 0 / cover`;
      }
    }
    return style;
  }
}