const OSS = require("ali-oss");
const path = require("path");
const fs = require('fs');

const prefix = process.env.COS_ENV === 'production' ? 'qb' : 'qb-test';
const cdnPrefix = `https://miscs.91xr.cn/${prefix}/`;

console.log('prefix', process.env);

class upload2Cos {
  constructor() {
    this.filesPath = [];
    this.instance = new OSS({
      region: 'oss-cn-beijing',
      bucket: 'qg-misc',
      accessKeyId: 'LTAI5tQoJrx4uYsG7CVSa9wn',
      accessKeySecret: 'JHhGqvrY6O6433Hz805efdM0TBUJO6',
    });
  }

  getFilesPath() {
    this._readFileList(path.resolve(__dirname, './public'), this.filesPath);
  }

  async upload() {
    this.getFilesPath();
    const filesCount = this.filesPath.length;
    try {
      for (let idx = 0; idx < this.filesPath.length; idx++) {
        const filepath = this.filesPath[idx];
        await this.instance.put(`${prefix}/public${filepath.split('public')[1]}`, path.normalize(filepath));
        let percent = (parseFloat((idx + 1) / filesCount) * 100).toFixed(2);
        console.log('进度：' + percent + '%');
      }
    } catch (error) {
      console.log(error);
    }
  }

  _isValid (path) {
    const format = ['.ico', '.html'];
    return !format.some(v => path.endsWith(v)) 
  }

  _readFileList(dir, filesPath = []) {
    const files = fs.readdirSync(dir);
    files.forEach((item, index) => {
      var fullPath = path.join(dir, item);
      const stat = fs.statSync(fullPath);
      if (stat.isDirectory()) {   
        this._readFileList(path.join(dir, item), filesPath);
      } else if(this._isValid(fullPath)) {        
        filesPath.push(fullPath);           
      }    
    });
    return filesPath;
  }
}

module.exports = {
  upload2Cos,
  cdnPrefix
};