import apolloSsr from '../../../config/apollo.ssr.json';
const protocol = EASY_ENV_IS_BROWSER ? window.location.protocol : 'https';

const hostMap = {
  apiHost: `${protocol}//quantum-blocks-bfe.liangkebang.net`,
  kdspHost: `${protocol}//talos-bfe.liangkebang.net`,
  shenceUrl: `${protocol}//bn.xyqb.com/sa?project=default`,
  mallHost: `${protocol}://mall-bfe.liangkebang.net`,
  test: true,
  yxmTenantId: 560761
};

if (EASY_ENV_IS_BROWSER) {
  const apolloWin = window.apollo || window.__INITIAL_STATE__.apollo;
  if (apolloWin) {
    for (const key in apolloWin) {
      if (apolloWin[key]) {
        hostMap[key] = apolloWin[key];
      }
    }
  }
}
if (EASY_ENV_IS_NODE) {
  if (apolloSsr) {
    for (const key in apolloSsr) {
      if (apolloSsr[key]) {
        hostMap[key] = apolloSsr[key];
      }
    }
  }
}

export default hostMap;
