// tslint:disable
// import store from '@/store';
import Toast from '@qg/cherry-ui/src/toast';
import axios from 'axios';
import strategyModes from '@/config/http.config';

const ERR_MESSAGE_MAP = {
  status: {
    400: '错误请求',
    401: '您未登录或登录超时，请重新登录',
    403: '拒绝访问',
    404: '请求错误,未找到该资源',
    405: '请求方法未允许',
    408: '请求超时',
    500: '服务器端出错',
    501: '网络未实现',
    502: '网络错误',
    503: '服务不可用',
    504: '网络超时',
    505: 'http版本不支持该请求'
  }
};
const defaultStratege = {
  default: {
    request(cfg) {
      return cfg;
    },
    response(res) {
      return res.data;
    }
  }
};

const config = {
  timeout: 15000
};
const CancelToken = axios.CancelToken;
const instance = axios.create(config);

const pending = {};
let reqNum = 0;
let timeId = null;
strategyModes.default = defaultStratege;

function beforeRequest() {
  reqNum++;
  clearTimeout(timeId);
  timeId = setTimeout(() => {
    // store.dispatch('change_loading', true);
  }, 1300);
}

function afterRequest() {
  reqNum--;
  if (reqNum <= 0) {
    clearRequest();
    // store.dispatch('change_loading', false);
  }
}

function clearRequest() {
  clearTimeout(timeId);
}

// 请求拦截器
instance.interceptors.request.use(
  config => {
    !config.hideLoading && beforeRequest(config?.url || '');
    // 发起请求时，取消掉当前正在进行的相同请求
    // if (pending[config.url]) {
    //   pending[config.url]('取消重复请求');
    // }
    // config.cancelToken = new CancelToken(c => (pending[config.url] = c));
    // 使用默认响应处理策略
    if (!config.strategy) {
      config.strategy = 'service';
    }
    if (strategyModes[config.strategy].request) {
      config = strategyModes[config.strategy].request(config);
    }
    return config;
  },
  error => {
    return [null, error];
  }
);

// 响应拦截器即异常处理
instance.interceptors.response.use(
  response => {
    if (response.config?.url) {
      !config.hideLoading && afterRequest();
      delete pending[response.config?.url || ''];
    }

    return strategyModes[response.config?.strategy].response(response);
  },
  err => {
    !config.hideLoading && afterRequest();

    let message = '';
    let showToast = true;

    if (err.message === 'Network Error' && !err.response) {
      // 网络异常: 错误域名，
      message = '服务不可用';
    } else if (err.response && err.response?.status) {
      message =
        ERR_MESSAGE_MAP.status[err.response?.status] || `未知异常码: ${err.response?.status}`;
    } else if (err.message === '取消重复请求') {
      message = '取消重复请求';
      showToast = false;
    }
    showToast && Toast(message || '服务异常，请稍后重试');
    const error = new Error(message);
    console.error(error);
    return [null, error];
  }
);
export default instance;
