import api from '@/api/editor.api';
import { Module, GetterTree, ActionTree, MutationTree } from 'vuex';
import Vue from 'vue';
import { UPDATE_PAGE_INFO, SET_PAGE_INFO, SET_PAGE_DATA, SET_PAGE_ELEMENTS, SET_ELEMENT_POINT, UPDATE_APP_LOGIN_STATE, SET_EMPTY_PAGE } from './type';

import RootState from '../../state';
import EditorState, { PageInfo, defaultState, Page, PageElement } from './state';

export default class EditorModule implements Module<EditorState, RootState> {
  state: EditorState;

  getters: GetterTree<EditorState, RootState> = {
    pageData(state) {
      return state.pageInfo.page;
    },
    pageInfo(state) {
      return state.pageInfo;
    }
  };

  actions: ActionTree<EditorState, RootState> = {
    async getPageDate({ commit }, condition) {
      const [res] = await api.getPageById(condition);
      if (res) {
        const { page, ...rest } = res as PageInfo;
        commit(SET_PAGE_INFO, { ...rest, page: JSON.parse(page as string) });
        commit(SET_EMPTY_PAGE, false);
      } else {
        commit(SET_EMPTY_PAGE, true);
      }
    }
  };

  mutations: MutationTree<EditorState> = {
    [SET_PAGE_INFO](state, data) {
      state.pageInfo = data;
    },
    [UPDATE_PAGE_INFO](state, { containerIndex, childIndex, data }) {
      const page = (state.pageInfo.page as Page).elements;
      if (childIndex || childIndex === 0) {
        page[containerIndex].child.splice(childIndex, 1, data);
      } else {
        page.splice(containerIndex, 1, data);
      }
    },
    [SET_PAGE_DATA](state, data) {
      state.pageInfo.page = data;
    },
    [UPDATE_APP_LOGIN_STATE](state, data) {
      state.pageInfo.appLoginState = data;
    },
    [SET_PAGE_ELEMENTS](state, data) {
      if (data) { (state.pageInfo.page as Page).elements = data; }
    },
    [SET_EMPTY_PAGE](state, data) {
      state.noPageData = data;
    },
    [SET_ELEMENT_POINT](state, { id, data }) {
      const elements = (state.pageInfo.page as Page).elements;
      const element = elements.find(ele => ele.id === id);
      if (element && data) { element.point = data; }
    },
  };

  constructor(initState: EditorState = JSON.parse(JSON.stringify(defaultState))) {
    this.state = initState;
  }
}