import { Vue, Component, Prop } from 'vue-property-decorator';
import { Getter } from 'vuex-class';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import 'intersection-observer';
import { release } from '@/.sentryclirc';
import '@/service/qg.service';
import SaDirective from '@qg/citrus-ui/src/helper/directives/saTrack.directive.js';
import config from '@qg/citrus-ui/src/config/index.js';
import { EventBus } from '@qg/citrus-ui/src/helper/service/eventBus';
import { getParameterByName } from '../../../service/utils.service';
import localStorage from '../../../service/localStorage.service';
import lazyload from '@qg/cherry-ui/src/lazyload/index';

// 初始化sentry
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('https://00ea2b4a57c94071a8d56f4548a42de2@sentry.quantgroups.com/66', {
    release,
    environment: 'production'
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

if (EASY_ENV_IS_BROWSER) {
  // ! 上线后务必取掉;
  // const vConsole = require('vconsole');
  // new vConsole();
}

if (EASY_ENV_IS_BROWSER) {
  // ios回退刷新，防止缓存
  const isSafari = /^.*((iPhone)|(iPad)|(Safari))+.*$/;
  const fromHost = getParameterByName('fromHost', window.location.href);
  if (isSafari.test(navigator.userAgent) && fromHost?.indexOf('xc.bmall') === -1 && fromHost?.indexOf('tob') === -1) {
    window.onpageshow = function(e) {
      if (e.persisted || (window.performance && window.performance.navigation.type === 2)) {
        window.location.reload();
      }
    };
  }
  Vue.use(lazyload);
  const saDirective = new SaDirective();
  Vue.directive('track', saDirective.directive);
  Vue.config.ignoredElements = ['wx-open-launch-weapp', 'wx-open-launch-app'];
  // 全局app登录态监听
  window.xyqbNativeEvent = function(res) {
    const json = typeof res === 'string' ? JSON.parse(res) : res;
    console.log('xyqbNativeEvent toggle');
    if (json.event === 'loginAndLogoutNotification') {
      EventBus.$emit('NATIVE_EVENT_LOGIN', json);
    }
    if (json.event === 'getTokenSuccess') {
      EventBus.$emit('NATIVE_EVENT_GET_TOKEN', json);
    }
  };
}
@Component({
  name: 'Layout'
})
export default class Layout extends Vue {
  @Getter('pageInfo') pageInfo;

  isNode: boolean = EASY_ENV_IS_NODE;

  scriptSrc: string[] = [
    // `<script src="https://activitystatic.lkbang.net/vue/2.6.11/vue.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vue-router/3.2.0/vue-router.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vuex/3.4.0/vuex.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/swiper/4.5.1/swiper.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/axios/0.19.2/axios.min.js"></script>`
  ];
  talosHost: string = config.kdspHost;
  get title() {
    return this.pageInfo.title || this.defaultTitle();
  }

  get description() {
    return this.pageInfo.description || this.defaultTitle();
  }

  get keywords() {
    return this.pageInfo.keywords || this.defaultTitle();
  }

  defaultTitle() {
    return +localStorage.get('tenantId') === 560671 ? '羊小咩' : '活动页';
  }
}