import { Vue, Component, Prop } from 'vue-property-decorator';
import { Getter } from 'vuex-class';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import 'intersection-observer';
import { release } from '@/.sentryclirc';
import '@/service/qg.service';
import SaDirective from '@qg/citrus-ui/src/helper/directives/saTrack.directive.js';
import config from '@qg/citrus-ui/src/config/index.js';
import { getParameterByName } from '../../../service/utils.service';
import lazyload from '@qg/cherry-ui/src/lazyload/index';

// 初始化sentry
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('https://00ea2b4a57c94071a8d56f4548a42de2@sentry.quantgroups.com/66', {
    release,
    environment: 'production'
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

// if (EASY_ENV_IS_BROWSER && process.env.SENTRY_ENV === 'test' || process.env.NODE_ENV !== 'production') {
//   // ! 上线后务必取掉;
//   const vConsole = require('vconsole');
//   new vConsole();
// }

if (EASY_ENV_IS_BROWSER) {
  const isSafari = /^.*((iPhone)|(iPad)|(Safari))+.*$/;
  if (isSafari.test(navigator.userAgent) && getParameterByName('fromHost', window.location.href)?.indexOf('xc.bmall') === -1) {
    window.onpageshow = function(e) {
      if (e.persisted || (window.performance && window.performance.navigation.type == 2) || ) {
        window.location.reload();
      }
    };
  }
  Vue.use(lazyload);
  const saDirective = new SaDirective();
  Vue.directive('track', saDirective.directive);
}
@Component({
  name: 'Layout'
})
export default class Layout extends Vue {
  @Getter('pageInfo') pageInfo;

  isNode: boolean = EASY_ENV_IS_NODE;

  scriptSrc: string[] = [
    // `<script src="https://activitystatic.lkbang.net/vue/2.6.11/vue.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vue-router/3.2.0/vue-router.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vuex/3.4.0/vuex.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/swiper/4.5.1/swiper.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/axios/0.19.2/axios.min.js"></script>`
  ];
  talosHost: string = config.kdspHost;

  get title() {
    return this.pageInfo.title || '羊小咩';
  }

  get description() {
    return this.pageInfo.description || '羊小咩';
  }

  get keywords() {
    return this.pageInfo.keywords || '羊小咩';
  }
}