// tslint:disable
export const chunk = function(array, size) {
  const result = [];
  let [start, end] = [null, null];
  for (let i = 0; i < Math.ceil(array.length / size); i++) {
    start = i * size;
    end = start + size;
    result.push(array.slice(start, end));
  }
  return result;
};

export const getParameterByName = function(name, url) {
  if (!url) {
    url = window.location.href;
  }
  name = name.replace(/[\[\]]/g, '\\$&');
  const regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)');
  const results = regex.exec(url);
  if (!results) {
    return null;
  }
  if (!results[2]) {
    return '';
  }
  return decodeURIComponent(results[2].replace(/\+/g, ' '));
};

// 判断输入内容是否为空
export function isNull(str) {
  return str === undefined || str.length === 0 || str === null;
}

// 判断手机号
export function isPhone(str) {
  if (!isNull(str)) {
    const reg = /^1[3456789]\d{9}$/;
    return reg.test(str);
  }
  return false;
}

export function resizeDiv(imgUrl, clientHeight = 0, clientWidth = 0, callback) {
  const img = new Image();
  clientHeight = clientHeight || document.body.clientHeight;
  clientWidth = clientWidth || document.body.clientWidth;
  img.onload = function() {
    const imgRealHeight = clientWidth * img.height / img.width;
    console.log(img.width, img.height, imgRealHeight, clientHeight);
    if (imgRealHeight > clientWidth) {
      callback(imgRealHeight);
    }
  };
  img.src = imgUrl;
}

const DK = {t: 'n', b: 's', l: 'w', r: 'e'}; // 上下左右 对应的 东南西北
export const convertPointStyle = (point, defaultStyle, directionKey = DK) => {
  const pos = defaultStyle;
  const height = pos.height;
  const width = pos.width;
  const hasT = /t/.test(point);
  const hasB = /b/.test(point);
  const hasL = /l/.test(point);
  const hasR = /r/.test(point);
  let newLeft = 0;
  let newTop = 0;
  if (point.length === 2) {
    newLeft = hasL ? 0 : width;
    newTop = hasT ? 0 : height;
  } else {
    // !#zh 上下点，宽度固定在中间
    if (hasT || hasB) {
      newLeft = width / 2 - 4;
      newTop = hasT ? 0 : height;
    }
    // !#zh 左右点，高度固定在中间
    if (hasL || hasR) {
      newLeft = hasL ? 0 : width;
      newTop = height / 2 - 4;
    }
  }
  const style = {
    marginLeft: (hasL || hasR) ? '-4px' : 0,
    marginTop: (hasT || hasB) ? '-4px' : 0,
    left: `${newLeft}px`,
    top: `${newTop}px`,
    cursor: point.split('').reverse().map(m => directionKey[m]).join('') + '-resize'
  };
  return style;
};

export const getStyle = function(oElement, sName) {
  const result = oElement.currentStyle ? oElement.currentStyle[sName] : getComputedStyle(oElement, null)[sName];
  return result.includes('px') ? result.slice(0, -2) : result;
};

export const validateType = function(obj) {
  const class2type = {};
  'Array Date RegExp Object Error'.split(' ').forEach(e => {
    class2type[`[object ${e}]`] = e.toLowerCase();
  });
  if (obj == null) { return String(obj); }
  return typeof obj === 'object' ? class2type[Object.prototype.toString.call(obj)] || 'object' : typeof obj;
};

export const transformStyle = function(styleObj = {}) {
  // console.log('transformStyle', styleObj);
  const style = {};
  for (const key of Object.keys(styleObj)) {
    if ( typeof styleObj[key] === 'number') {
      style[key] = `${(styleObj[key] / 37.5).toFixed(3)}rem`;
    } else {
      style[key] = styleObj[key].includes('px') ? `${(+(styleObj[key].slice(0, -2)) / 37.5).toFixed(3)}rem` : styleObj[key];
    }
    if (key === 'backgroundImage' && style.backgroundImage) {
      style.background = `url(${style.backgroundImage}) no-repeat 0 0 / cover`;
    }
  }
  return style;
};

const ua = !EASY_ENV_IS_BROWSER ? { match() {} } : window.navigator.userAgent.toLowerCase();
// 判断微信环境
export const isWechat = ua.match(/MicroMessenger/i) == "micromessenger";

// 判断羊小咩（信用钱包）环境
export const isApp = ua.match(/xyqb/i) == "xyqb";

// 判断真享生活
export const isVcc = ua.match(/VCC/i) == "vcc";

// 判断IOS环境
export const isIOS = /iphone|ipad|ipod/.test(ua);

// 判读Android环境
export const isAndroid = /android/.test(ua);

// 异常字段
export const errorQueryValues = ['{token}', '{vccToken}', '{registerFrom}', '{vccChannel}', '{h}', '{uuid}', '{}'];

export const debounce = (event, time) => {
  let timer = null;
  return function (...args) {
    clearTimeout(timer);
    timer = setTimeout(() => event.apply(this, args), time);
  }
}

export const throttle = (event, time) => {
  let timer = null;
  return function (...args) {
    if (!timer) {
      timer = setTimeout(() => {
        timer = null;
        clearTimeout(timer);
        event.apply(this, args)
      }, time);
    }
  }
}
