import { Vue, Component, Prop } from 'vue-property-decorator';
import { Getter } from 'vuex-class';
import Raven from 'raven-js';
import RavenVue from 'raven-js/plugins/vue';
import 'intersection-observer';
import { release } from '@/.sentryclirc';
import '@/service/qg.service';
import Exposure from '@/service/exposure.service';

// 初始化sentry
if (process.env.SENTRY_ENV !== 'test' && process.env.NODE_ENV === 'production') {
  Raven.config('http://0785298052fd46128e201f30ca649102@sentry.q-gp.com/64', {
    release,
    environment: 'production'
  })
    .addPlugin(RavenVue, Vue)
    .install();
}

if (EASY_ENV_IS_BROWSER) {
  const exp = new Exposure();

  Vue.directive('exp-dot', {
    bind(el, binding, vnode) {
      exp.add({el, val: binding.value});
    }
  });
}

@Component({
  name: 'Layout'
})
export default class Layout extends Vue {
  @Getter('pageInfo') pageInfo;

  isNode: boolean = EASY_ENV_IS_NODE;

  scriptSrc: string[] = [
    // `<script src="https://activitystatic.lkbang.net/vue/2.6.11/vue.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vue-router/3.2.0/vue-router.min.js"></script>`,
    // `<script src="https://activitystatic.lkbang.net/vuex/3.4.0/vuex.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/sa-sdk-javascript/1.15.16/sensorsdata.min.js"></script>`,
    `<script src="https://activitystatic.lkbang.net/swiper/4.5.1/swiper.min.js"></script>`,
    `<script src="https://cdn.bootcss.com/axios/0.19.2/axios.min.js"></script>`
  ];

  get title() {
    return this.pageInfo.title || '羊小咩';
  }

  get description() {
    return this.pageInfo.description || '羊小咩';
  }

  get keywords() {
    return this.pageInfo.keywords || '羊小咩';
  }
}