import { Controller, Context } from 'egg';
import * as path from 'path';
export default class ActivityController extends Controller {

  public async home(ctx: Context) {
    const { api, qiniu } = await import(path.resolve('./config/apollo.json'));
    const redisKey = `quantum-blocks:page:${ctx.params.id}`;
    let body = await ctx.service.redis.get(redisKey);
    if (body) {
      ctx.logger.info('请求redis成功 key: %j', redisKey);
    }
    if (!body) {
      body = await ctx.renderView('activity.js', { url: ctx.url });
      await ctx.service.redis.set(redisKey, body);
    }
    if (process.env.NODE_ENV === 'production') {
      const firstScriptTagIndex = body.indexOf('<script');
      body = `${body.slice(0, firstScriptTagIndex)}<script>var apollo = ${JSON.stringify({...api, ...qiniu} )};</script>${body.slice(firstScriptTagIndex, body.length - 1)}`;
    }
    ctx.body = body;
  }
}