import { Component, Prop, Vue, Mixins } from 'vue-property-decorator';
import { Action, Mutation, State, Getter } from 'vuex-class';
import TransformStyleMixin from '@/page/mixins/transformStyle.mixin';
import SaMixin from '@/page/mixins/sa.mixin';
import localStorage from '@/service/localStorage.service';
// import { resizeDiv } from '@/service/utils.service';
import { locationHrefPatchDelay, getTokenFromApp, parseSearch, locationHrefPatchNoHandleParams } from '@qg/citrus-ui/src/helper/service/utils';
import saTrackMixins from '@qg/citrus-ui/src/helper/mixins/saTrack.mixins';

@Component({ name: 'FreedomContainer' })
export default class FreedomContainer extends Mixins(TransformStyleMixin, SaMixin, saTrackMixins) {
  @Getter('pageData') pageData;
  @State(state => state.activity.curChildIndex) curChildIndex;
  // showVideo = false;
  @Mutation('UPDATE_PAGE_INFO') updatePageInfo;
  @Prop({type: Object, default: () => ({ child: [] })}) childItem;
  @Prop({type: Object, default: () => ({})}) saInfo;
  @Prop(String) link;
  @Prop(String) backgroundImage;

  clickEvent() {
    let needLogin = false;
    try {
      needLogin = this.childItem.props.needLogin;
    } catch (err) {
      console.log(err);
    }
    if (this.childItem.props.isFinance) {
      let paramsStr = '', url = this.childItem.props.link;
      const localStorageParams = [
        'token',
        'tchannel',
        'tenantId',
        'appChannel',
        'appName'
      ];
      const params = parseSearch(this.childItem.props.link);
      localStorageParams.forEach(item => {
        let key = item;
        if (item == 'token') {
          key = 'vccToken';
        }
        if (item == 'tchannel') {
          key = 'vccChannel';
        }
        const itemVal = localStorage.get(key);
        params[item] = itemVal || '';
      });
      Object.keys(params).forEach(item => {
        paramsStr += `&${item}=${params[item]}`;
      });
      const targetUrl = `${url.split('?')[0]}?${paramsStr.slice(1)}`;
      locationHrefPatchNoHandleParams(targetUrl);
      return;
    }
    if (needLogin) {
      getTokenFromApp().then(hasLogin => {
        if (hasLogin) {
          locationHrefPatchDelay(this.link);
        }
      });
    } else {
      console.log(this.link);
      locationHrefPatchDelay(this.link);
    }
  }

  mounted() {
    // this.showVideo = true;
    // 根据背景图设置元素高度
    // const index = this.pageData?.elements?.findIndex(v => v.point?.responsive);
    // const { props: { backgroundImage }, point } = this.pageData?.elements[index] || { props: {}};
    // if (backgroundImage) {
    //   resizeDiv(backgroundImage, null, null, (height) => {
    //     this.updatePageInfo({ containerIndex: index, data: { ...this.pageData?.elements[index], point: { ...point, h: height ?? point.h } } });
    //   });
    // }
  }

}
